/*
 * Decompiled with CFR 0.152.
 */
package com.moowork.gradle.node.npm;

import com.moowork.gradle.node.exec.ExecRunner;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.tasks.Internal;
import org.gradle.process.ExecResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\u0006H\u0015J\b\u0010\n\u001a\u00020\u0006H\u0015J\b\u0010\u000b\u001a\u00020\fH\u0015\u00a8\u0006\r"}, d2={"Lcom/moowork/gradle/node/npm/NpmExecRunner;", "Lcom/moowork/gradle/node/exec/ExecRunner;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "computeAdditionalBinPath", "", "doExecute", "Lorg/gradle/process/ExecResult;", "getCommand", "getCommandScript", "getLocalCommandScript", "Ljava/io/File;", "gradle-node-plugin"})
public class NpmExecRunner
extends ExecRunner {
    @Override
    @NotNull
    protected ExecResult doExecute() {
        String exec = this.getCommand();
        List arguments = CollectionsKt.toMutableList((Collection)this.getArguments());
        if (this.getExt().getDownload()) {
            File localNpm = this.getLocalCommandScript();
            if (localNpm.exists()) {
                exec = this.getVariant().getNodeExec();
                String string = localNpm.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localNpm.absolutePath");
                arguments.add(0, string);
            } else if (!new File(exec).exists()) {
                exec = this.getVariant().getNodeExec();
                arguments.add(0, this.getCommandScript());
            }
        }
        return this.run(exec, arguments);
    }

    @Override
    @NotNull
    protected String computeAdditionalBinPath() {
        if (!this.getExt().getDownload()) {
            return "";
        }
        String npmBinDir = this.getVariant().getNpmBinDir().getAbsolutePath();
        String nodeBinDir = this.getVariant().getNodeBinDir().getAbsolutePath();
        return npmBinDir + File.pathSeparator + nodeBinDir;
    }

    @Internal
    @NotNull
    protected String getCommand() {
        return this.getVariant().getNpmExec();
    }

    @Internal
    @NotNull
    protected File getLocalCommandScript() {
        File file = this.getProject().file((Object)new File(this.getExt().getNodeModulesDir(), "node_modules/npm/bin/npm-cli.js"));
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"this.project.file(File(e\u2026les/npm/bin/npm-cli.js\"))");
        return file;
    }

    @Internal
    @NotNull
    protected String getCommandScript() {
        return this.getVariant().getNpmScriptFile();
    }

    public NpmExecRunner(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project);
    }
}

