/*
 * Decompiled with CFR 0.152.
 */
package com.github.nkzawa.socketio.client;

import com.github.nkzawa.emitter.Emitter;
import com.github.nkzawa.engineio.client.Socket;
import com.github.nkzawa.socketio.client.IO;
import com.github.nkzawa.socketio.client.On;
import com.github.nkzawa.socketio.client.Socket;
import com.github.nkzawa.socketio.client.SocketIOException;
import com.github.nkzawa.socketio.parser.Packet;
import com.github.nkzawa.socketio.parser.Parser;
import com.github.nkzawa.thread.EventThread;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class Manager
extends Emitter {
    private static final Logger logger = Logger.getLogger(Manager.class.getName());
    public static final String EVENT_OPEN = "open";
    public static final String EVENT_CLOSE = "close";
    public static final String EVENT_PACKET = "packet";
    public static final String EVENT_ERROR = "error";
    public static final String EVENT_CONNECT_ERROR = "connect_error";
    public static final String EVENT_CONNECT_TIMEOUT = "connect_timeout";
    public static final String EVENT_RECONNECT = "reconnect";
    public static final String EVENT_RECONNECT_ERROR = "reconnect_error";
    public static final String EVENT_RECONNECT_FAILED = "reconnect_failed";
    public static final String EVENT_RECONNECT_ATTEMPT = "reconnect_attempt";
    ReadyState readyState = null;
    private boolean _reconnection;
    private boolean skipReconnect;
    private boolean reconnecting;
    private boolean encoding;
    private boolean openReconnect;
    private int _reconnectionAttempts;
    private long _reconnectionDelay;
    private long _reconnectionDelayMax;
    private long _timeout;
    private int connected;
    private int attempts;
    private URI uri;
    private List<Packet> packetBuffer;
    private Queue<On.Handle> subs;
    private IO.Options opts;
    com.github.nkzawa.engineio.client.Socket engine;
    private Parser.Encoder encoder;
    private Parser.Decoder decoder;
    private ConcurrentHashMap<String, Socket> nsps;
    private ScheduledExecutorService timeoutScheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledExecutorService reconnectScheduler = Executors.newSingleThreadScheduledExecutor();

    public Manager() {
        this(null, null);
    }

    public Manager(URI uri) {
        this(uri, null);
    }

    public Manager(IO.Options opts) {
        this(null, opts);
    }

    public Manager(URI uri, IO.Options opts) {
        if (opts == null) {
            opts = new IO.Options();
        }
        if (opts.path == null) {
            opts.path = "/socket.io";
        }
        this.opts = opts;
        this.nsps = new ConcurrentHashMap();
        this.subs = new LinkedList<On.Handle>();
        this.reconnection(opts.reconnection);
        this.reconnectionAttempts(opts.reconnectionAttempts != 0 ? opts.reconnectionAttempts : Integer.MAX_VALUE);
        this.reconnectionDelay(opts.reconnectionDelay != 0L ? opts.reconnectionDelay : 1000L);
        this.reconnectionDelayMax(opts.reconnectionDelayMax != 0L ? opts.reconnectionDelayMax : 5000L);
        this.timeout(opts.timeout < 0L ? 20000L : opts.timeout);
        this.readyState = ReadyState.CLOSED;
        this.uri = uri;
        this.connected = 0;
        this.attempts = 0;
        this.encoding = false;
        this.packetBuffer = new ArrayList<Packet>();
        this.encoder = new Parser.Encoder();
        this.decoder = new Parser.Decoder();
    }

    public boolean reconnection() {
        return this._reconnection;
    }

    public Manager reconnection(boolean v) {
        this._reconnection = v;
        return this;
    }

    public int reconnectionAttempts() {
        return this._reconnectionAttempts;
    }

    public Manager reconnectionAttempts(int v) {
        this._reconnectionAttempts = v;
        return this;
    }

    public long reconnectionDelay() {
        return this._reconnectionDelay;
    }

    public Manager reconnectionDelay(long v) {
        this._reconnectionDelay = v;
        return this;
    }

    public long reconnectionDelayMax() {
        return this._reconnectionDelayMax;
    }

    public Manager reconnectionDelayMax(long v) {
        this._reconnectionDelayMax = v;
        return this;
    }

    public long timeout() {
        return this._timeout;
    }

    public Manager timeout(long v) {
        this._timeout = v;
        return this;
    }

    private void maybeReconnectOnOpen() {
        if (!this.openReconnect && !this.reconnecting && this._reconnection) {
            this.openReconnect = true;
            this.reconnect();
        }
    }

    public Manager open() {
        return this.open(null);
    }

    public Manager open(final OpenCallback fn) {
        EventThread.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                logger.fine(String.format("readyState %s", new Object[]{Manager.this.readyState}));
                if (Manager.this.readyState == ReadyState.OPEN) {
                    return;
                }
                logger.fine(String.format("opening %s", Manager.this.uri));
                final com.github.nkzawa.engineio.client.Socket socket = Manager.this.engine = new Engine(Manager.this.uri, Manager.this.opts);
                final Manager self = Manager.this;
                Manager.this.readyState = ReadyState.OPENING;
                final On.Handle openSub = On.on((Emitter)socket, Manager.EVENT_OPEN, new Emitter.Listener(){

                    public void call(Object ... objects) {
                        self.onopen();
                        if (fn != null) {
                            fn.call(null);
                        }
                    }
                });
                On.Handle errorSub = On.on((Emitter)socket, Manager.EVENT_ERROR, new Emitter.Listener(){

                    public void call(Object ... objects) {
                        Object data = objects.length > 0 ? objects[0] : null;
                        logger.fine(Manager.EVENT_CONNECT_ERROR);
                        self.cleanup();
                        self.readyState = ReadyState.CLOSED;
                        self.emit(Manager.EVENT_CONNECT_ERROR, new Object[]{data});
                        if (fn != null) {
                            SocketIOException err = new SocketIOException("Connection error", data instanceof Exception ? (Exception)data : null);
                            fn.call(err);
                        }
                        self.maybeReconnectOnOpen();
                    }
                });
                if (Manager.this._timeout >= 0L) {
                    final long timeout = Manager.this._timeout;
                    logger.fine(String.format("connection attempt will timeout after %d", timeout));
                    final ScheduledFuture<?> timer = Manager.this.timeoutScheduler.schedule(new Runnable(){

                        @Override
                        public void run() {
                            EventThread.exec((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    logger.fine(String.format("connect attempt timed out after %d", timeout));
                                    openSub.destroy();
                                    socket.close();
                                    socket.emit(Manager.EVENT_ERROR, new Object[]{new SocketIOException("timeout")});
                                    self.emit(Manager.EVENT_CONNECT_TIMEOUT, new Object[]{timeout});
                                }
                            });
                        }
                    }, timeout, TimeUnit.MILLISECONDS);
                    Manager.this.subs.add(new On.Handle(){

                        @Override
                        public void destroy() {
                            timer.cancel(false);
                        }
                    });
                }
                Manager.this.subs.add(openSub);
                Manager.this.subs.add(errorSub);
                Manager.this.engine.open();
            }
        });
        return this;
    }

    private void onopen() {
        logger.fine(EVENT_OPEN);
        this.cleanup();
        this.readyState = ReadyState.OPEN;
        this.emit(EVENT_OPEN, new Object[0]);
        com.github.nkzawa.engineio.client.Socket socket = this.engine;
        this.subs.add(On.on((Emitter)socket, "data", new Emitter.Listener(){

            public void call(Object ... objects) {
                Object data = objects[0];
                if (data instanceof String) {
                    Manager.this.ondata((String)data);
                } else if (data instanceof byte[]) {
                    Manager.this.ondata((byte[])data);
                }
            }
        }));
        this.subs.add(On.on(this.decoder, Parser.Decoder.EVENT_DECODED, new Emitter.Listener(){

            public void call(Object ... objects) {
                Manager.this.ondecoded((Packet)objects[0]);
            }
        }));
        this.subs.add(On.on((Emitter)socket, EVENT_ERROR, new Emitter.Listener(){

            public void call(Object ... objects) {
                Manager.this.onerror((Exception)objects[0]);
            }
        }));
        this.subs.add(On.on((Emitter)socket, EVENT_CLOSE, new Emitter.Listener(){

            public void call(Object ... objects) {
                Manager.this.onclose((String)objects[0]);
            }
        }));
    }

    private void ondata(String data) {
        this.decoder.add(data);
    }

    private void ondata(byte[] data) {
        this.decoder.add(data);
    }

    private void ondecoded(Packet packet) {
        this.emit(EVENT_PACKET, new Object[]{packet});
    }

    private void onerror(Exception err) {
        this.emit(EVENT_ERROR, new Object[]{err});
    }

    public Socket socket(String nsp) {
        Socket socket = this.nsps.get(nsp);
        if (socket == null) {
            socket = new Socket(this, nsp);
            Socket _socket = this.nsps.putIfAbsent(nsp, socket);
            if (_socket != null) {
                socket = _socket;
            } else {
                final Manager self = this;
                socket.on("connect", new Emitter.Listener(){

                    public void call(Object ... objects) {
                        self.connected++;
                    }
                });
            }
        }
        return socket;
    }

    void destroy(Socket socket) {
        --this.connected;
        if (this.connected == 0) {
            this.close();
        }
    }

    void packet(Packet packet) {
        logger.fine(String.format("writing packet %s", packet));
        final Manager self = this;
        if (!self.encoding) {
            self.encoding = true;
            this.encoder.encode(packet, new Parser.Encoder.Callback(){

                @Override
                public void call(Object[] encodedPackets) {
                    for (Object packet : encodedPackets) {
                        if (packet instanceof String) {
                            self.engine.write((String)packet);
                            continue;
                        }
                        if (!(packet instanceof byte[])) continue;
                        self.engine.write((byte[])packet);
                    }
                    self.encoding = false;
                    self.processPacketQueue();
                }
            });
        } else {
            self.packetBuffer.add(packet);
        }
    }

    private void processPacketQueue() {
        if (this.packetBuffer.size() > 0 && !this.encoding) {
            Packet pack = this.packetBuffer.remove(0);
            this.packet(pack);
        }
    }

    private void cleanup() {
        On.Handle sub;
        while ((sub = this.subs.poll()) != null) {
            sub.destroy();
        }
    }

    private void close() {
        this.skipReconnect = true;
        this.engine.close();
    }

    private void onclose(String reason) {
        logger.fine(EVENT_CLOSE);
        this.cleanup();
        this.readyState = ReadyState.CLOSED;
        this.emit(EVENT_CLOSE, new Object[]{reason});
        if (this._reconnection && !this.skipReconnect) {
            this.reconnect();
        }
    }

    private void reconnect() {
        if (this.reconnecting) {
            return;
        }
        final Manager self = this;
        ++this.attempts;
        if (this.attempts > this._reconnectionAttempts) {
            logger.fine("reconnect failed");
            this.emit(EVENT_RECONNECT_FAILED, new Object[0]);
            this.reconnecting = false;
        } else {
            long delay = (long)this.attempts * this.reconnectionDelay();
            delay = Math.min(delay, this.reconnectionDelayMax());
            logger.fine(String.format("will wait %dms before reconnect attempt", delay));
            this.reconnecting = true;
            final ScheduledFuture<?> timer = this.reconnectScheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    EventThread.exec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            logger.fine("attempting reconnect");
                            self.emit(Manager.EVENT_RECONNECT_ATTEMPT, new Object[0]);
                            self.open(new OpenCallback(){

                                @Override
                                public void call(Exception err) {
                                    if (err != null) {
                                        logger.fine("reconnect attempt error");
                                        self.reconnecting = false;
                                        self.reconnect();
                                        self.emit(Manager.EVENT_RECONNECT_ERROR, new Object[]{err});
                                    } else {
                                        logger.fine("reconnect success");
                                        self.onreconnect();
                                    }
                                }
                            });
                        }
                    });
                }
            }, delay, TimeUnit.MILLISECONDS);
            this.subs.add(new On.Handle(){

                @Override
                public void destroy() {
                    timer.cancel(false);
                }
            });
        }
    }

    private void onreconnect() {
        int attempts = this.attempts;
        this.attempts = 0;
        this.reconnecting = false;
        this.emit(EVENT_RECONNECT, new Object[]{attempts});
    }

    private static class Engine
    extends com.github.nkzawa.engineio.client.Socket {
        Engine(URI uri, Socket.Options opts) {
            super(uri, opts);
        }
    }

    public static interface OpenCallback {
        public void call(Exception var1);
    }

    static enum ReadyState {
        CLOSED,
        OPENING,
        OPEN;

    }
}

