/*
 * Decompiled with CFR 0.152.
 */
package com.github.nkzawa.thread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class EventThread
extends Thread {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            thread = new EventThread(runnable);
            return thread;
        }
    };
    private static volatile EventThread thread;
    private static ExecutorService service;
    private static int counter;

    private EventThread(Runnable runnable) {
        super(runnable);
    }

    public static boolean isCurrent() {
        return EventThread.currentThread() == thread;
    }

    public static void exec(Runnable task) {
        if (EventThread.isCurrent()) {
            task.run();
        } else {
            EventThread.nextTick(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nextTick(final Runnable task) {
        Class<EventThread> clazz = EventThread.class;
        synchronized (EventThread.class) {
            ++counter;
            if (service == null || service.isShutdown()) {
                service = Executors.newSingleThreadExecutor(THREAD_FACTORY);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            service.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        task.run();
                    }
                    finally {
                        Class<EventThread> clazz = EventThread.class;
                        synchronized (EventThread.class) {
                            counter--;
                            if (counter == 0) {
                                service.shutdown();
                                thread = null;
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                        }
                    }
                }
            });
            return;
        }
    }

    static {
        counter = 0;
    }
}

