/*
 * Decompiled with CFR 0.152.
 */
package com.github.nisrulz.zentone;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import com.github.nisrulz.zentone.internal.InternalUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u001a\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\t\u001a\u00020\u0003\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\u0001\u00a8\u0006\u000b"}, d2={"initAudioTrack", "Landroid/media/AudioTrack;", "sampleRate", "", "encoding", "channelMask", "setThreadPriority", "", "setVolumeLevel", "level", "stopAndRelease", "zentone_release"})
public final class AudioUtilsKt {
    public static final void setThreadPriority() {
        Process.setThreadPriority((int)-16);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final AudioTrack initAudioTrack(int sampleRate, int encoding, int channelMask) {
        AudioTrack audioTrack;
        void var2_3;
        int n;
        void var1_2;
        int n2 = InternalUtilsKt.minBufferSize(sampleRate);
        if (Build.VERSION.SDK_INT >= 23) {
            audioTrack = new AudioTrack.Builder().setAudioAttributes(new AudioAttributes.Builder().setUsage(1).setContentType(2).build()).setAudioFormat(new AudioFormat.Builder().setEncoding((int)var1_2).setSampleRate(n).setChannelMask((int)var2_3).build()).setBufferSizeInBytes(n2).build();
            Intrinsics.checkNotNullExpressionValue((Object)audioTrack, (String)"{\n        AudioTrack.Bui\u2026           .build()\n    }");
        } else {
            AudioTrack audioTrack2;
            AudioTrack audioTrack3 = audioTrack2;
            audioTrack2 = new AudioTrack(3, n, (int)var2_3, (int)var1_2, n2, 1);
            audioTrack = audioTrack3;
        }
        return audioTrack;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void stopAndRelease(@NotNull AudioTrack $this$stopAndRelease) {
        AudioTrack audioTrack;
        Throwable throwable2;
        block4: {
            AudioTrack audioTrack2 = $this$stopAndRelease;
            AudioTrack audioTrack3 = audioTrack2;
            Intrinsics.checkNotNullParameter((Object)audioTrack2, (String)"<this>");
            audioTrack2.stop();
            {
                catch (Throwable throwable2) {
                    break block4;
                }
                catch (Exception exception) {}
                {
                    audioTrack3 = audioTrack;
                    exception.printStackTrace();
                }
            }
            audioTrack3.release();
            return;
        }
        audioTrack.release();
        throw throwable2;
    }

    public static final void setVolumeLevel(@NotNull AudioTrack $this$setVolumeLevel, int level) {
        float f;
        float f2;
        AudioTrack audioTrack;
        Intrinsics.checkNotNullParameter((Object)audioTrack, (String)"<this>");
        float f3 = InternalUtilsKt.convertIntRangeToFloatRange(level);
        float f4 = AudioTrack.getMaxVolume();
        if (f2 > f) {
            f3 = f4;
        } else if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            audioTrack.setVolume(f3);
        } else {
            float f5 = f3;
            audioTrack.setStereoVolume(f5, f5);
        }
    }
}

