/*
 * Decompiled with CFR 0.152.
 */
package github.nisrulz.lantern;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.view.Window;
import android.view.WindowManager;
import github.nisrulz.lantern.DisplayLightController;
import github.nisrulz.lantern.Utils;
import java.lang.ref.WeakReference;

class DisplayLightControllerImpl
implements DisplayLightController {
    private WeakReference<Activity> activityWeakRef;

    public DisplayLightControllerImpl(Activity activity) {
        this.activityWeakRef = new WeakReference<Activity>(activity);
    }

    @Override
    public boolean checkSystemWritePermission() {
        boolean retVal = true;
        if (Build.VERSION.SDK_INT >= 23) {
            retVal = Settings.System.canWrite((Context)((Activity)this.activityWeakRef.get()).getApplicationContext());
        }
        return retVal;
    }

    @Override
    public void cleanup() {
        this.activityWeakRef = null;
    }

    @Override
    public void disableAlwaysOnMode() {
        ((Activity)this.activityWeakRef.get()).getWindow().clearFlags(128);
    }

    @Override
    public void disableAutoBrightMode() {
        this.disableFullBrightMode();
    }

    @Override
    public void disableFullBrightMode() {
        if (this.checkSystemWritePermission()) {
            Settings.System.putInt((ContentResolver)((Activity)this.activityWeakRef.get()).getContentResolver(), (String)"screen_brightness_mode", (int)0);
            Window window = ((Activity)this.activityWeakRef.get()).getWindow();
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            layoutParams.screenBrightness = 0.1f;
            window.setAttributes(layoutParams);
        }
    }

    @Override
    public void enableAlwaysOnMode() {
        ((Activity)this.activityWeakRef.get()).getWindow().addFlags(128);
    }

    @Override
    public void enableAutoBrightMode() {
        if (this.checkSystemWritePermission()) {
            Settings.System.putInt((ContentResolver)((Activity)this.activityWeakRef.get()).getContentResolver(), (String)"screen_brightness_mode", (int)1);
        }
    }

    @Override
    public void enableFullBrightMode() {
        if (this.checkSystemWritePermission()) {
            Settings.System.putInt((ContentResolver)((Activity)this.activityWeakRef.get()).getContentResolver(), (String)"screen_brightness_mode", (int)0);
            Window window = ((Activity)this.activityWeakRef.get()).getWindow();
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            layoutParams.screenBrightness = 1.0f;
            window.setAttributes(layoutParams);
        }
    }

    @Override
    public void requestSystemWritePermission() {
        if (!this.checkSystemWritePermission() && Utils.isMarshmallowAndAbove()) {
            Intent intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
            intent.setData(Uri.parse((String)("package:" + ((Activity)this.activityWeakRef.get()).getPackageName())));
            ((Activity)this.activityWeakRef.get()).startActivity(intent);
        }
    }
}

