/*
 * Decompiled with CFR 0.152.
 */
package github.nisrulz.lantern;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.RequiresPermission;
import android.view.Window;
import android.view.WindowManager;
import github.nisrulz.lantern.PostMarshmallow;
import github.nisrulz.lantern.PreMarshmallow;

public class Lantern {
    private boolean isFlashOn = false;
    private PostMarshmallow postMarshmallow;
    private PreMarshmallow preMarshmallow;

    private Lantern() {
    }

    public static Lantern getInstance() {
        return LazyHolder.INSTANCE;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void init(Context context) {
        if (this.checkIfCameraFeatureExists(context)) {
            if (this.isMarshmallowAndAbove()) {
                this.postMarshmallow = new PostMarshmallow(context);
            } else {
                this.preMarshmallow = new PreMarshmallow();
            }
        }
    }

    public void turnOnFlashlight(Context context) {
        if (!this.isFlashOn && this.checkForCameraPermission(context)) {
            if (this.isMarshmallowAndAbove()) {
                this.postMarshmallow.turnOn();
            } else {
                this.preMarshmallow.turnOn();
            }
            this.isFlashOn = true;
        }
    }

    public void turnOffFlashlight(Context context) {
        if (this.isFlashOn && this.checkForCameraPermission(context)) {
            if (this.isMarshmallowAndAbove()) {
                this.postMarshmallow.turnOff();
            } else {
                this.preMarshmallow.turnOff();
            }
            this.isFlashOn = false;
        }
    }

    public void clearKeepDisplayOn(Activity activity) {
        activity.getWindow().clearFlags(128);
    }

    public void keepDisplayOn(Activity activity) {
        activity.getWindow().addFlags(128);
    }

    public void setDisplayToFullBright(Activity activity) {
        if (this.checkSystemWritePermission(activity)) {
            Settings.System.putInt((ContentResolver)activity.getContentResolver(), (String)"screen_brightness_mode", (int)0);
            Window window = activity.getWindow();
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            layoutParams.screenBrightness = 1.0f;
            window.setAttributes(layoutParams);
        }
    }

    public void resetDisplayToAutoBright(Activity activity) {
        if (this.checkSystemWritePermission(activity)) {
            Settings.System.putInt((ContentResolver)activity.getContentResolver(), (String)"screen_brightness_mode", (int)1);
        }
    }

    public boolean checkSystemWritePermission(Activity activity) {
        boolean retVal = true;
        if (Build.VERSION.SDK_INT >= 23) {
            retVal = Settings.System.canWrite((Context)activity);
        }
        return retVal;
    }

    public void requestSystemWritePermission(Activity activity) {
        if (Build.VERSION.SDK_INT >= 23) {
            Intent intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
            intent.setData(Uri.parse((String)("package:" + activity.getPackageName())));
            activity.startActivity(intent);
        }
    }

    private boolean isMarshmallowAndAbove() {
        return Build.VERSION.SDK_INT >= 23;
    }

    private boolean checkForCameraPermission(Context context) {
        return context.checkCallingOrSelfPermission("android.permission.CAMERA") == 0;
    }

    private boolean checkIfCameraFeatureExists(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }

    private static class LazyHolder {
        static final Lantern INSTANCE = new Lantern();

        private LazyHolder() {
        }
    }
}

