/*
 * Decompiled with CFR 0.152.
 */
package com.github.niqdev.mjpeg;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.github.niqdev.mjpeg.MjpegInputStream;
import com.github.niqdev.mjpeg.MjpegInputStreamDefault;
import com.github.niqdev.mjpeg.MjpegInputStreamNative;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;

public class Mjpeg {
    private static final String TAG = Mjpeg.class.getSimpleName();
    private static CookieManager msCookieManager = new CookieManager();
    private final Type type;
    private boolean sendConnectionCloseHeader = false;

    private Mjpeg(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("null type not allowed");
        }
        this.type = type;
    }

    public static Mjpeg newInstance() {
        return new Mjpeg(Type.DEFAULT);
    }

    public static Mjpeg newInstance(Type type) {
        return new Mjpeg(type);
    }

    public Mjpeg credential(final String username, final String password) {
        if (!TextUtils.isEmpty((CharSequence)username) && !TextUtils.isEmpty((CharSequence)password)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            });
        }
        return this;
    }

    public Mjpeg addCookie(String cookie) {
        if (!TextUtils.isEmpty((CharSequence)cookie)) {
            msCookieManager.getCookieStore().add(null, HttpCookie.parse(cookie).get(0));
        }
        return this;
    }

    public Mjpeg sendConnectionCloseHeader() {
        this.sendConnectionCloseHeader = true;
        return this;
    }

    @NonNull
    private Observable<MjpegInputStream> connect(String url) {
        return Observable.defer(() -> {
            try {
                HttpURLConnection urlConnection = (HttpURLConnection)new URL(url).openConnection();
                this.loadConnectionProperties(urlConnection);
                InputStream inputStream = urlConnection.getInputStream();
                switch (this.type) {
                    case DEFAULT: {
                        return Observable.just((Object)new MjpegInputStreamDefault(inputStream));
                    }
                    case NATIVE: {
                        return Observable.just((Object)new MjpegInputStreamNative(inputStream));
                    }
                }
                throw new IllegalStateException("invalid type");
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"error during connection", (Throwable)e);
                return Observable.error((Throwable)e);
            }
        });
    }

    public Observable<MjpegInputStream> open(String url) {
        return this.connect(url).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Observable<MjpegInputStream> open(String url, int timeout) {
        return this.connect(url).timeout((long)timeout, TimeUnit.SECONDS).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private void loadConnectionProperties(HttpURLConnection urlConnection) {
        urlConnection.setRequestProperty("Cache-Control", "no-cache");
        if (this.sendConnectionCloseHeader) {
            urlConnection.setRequestProperty("Connection", "close");
        }
        if (!msCookieManager.getCookieStore().getCookies().isEmpty()) {
            urlConnection.setRequestProperty("Cookie", TextUtils.join((CharSequence)";", msCookieManager.getCookieStore().getCookies()));
        }
    }

    public static enum Type {
        DEFAULT,
        NATIVE;

    }
}

