/*
 * Decompiled with CFR 0.152.
 */
package com.github.niqdev.mjpeg;

import com.github.niqdev.mjpeg.Mjpeg$$Lambda$1;
import com.github.niqdev.mjpeg.MjpegInputStream;
import com.github.niqdev.mjpeg.MjpegInputStreamDefault;
import com.github.niqdev.mjpeg.MjpegInputStreamNative;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import rx.Observable;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func0;
import rx.schedulers.Schedulers;

public class Mjpeg {
    private final Type type;

    private Mjpeg(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("null type not allowed");
        }
        this.type = type;
    }

    public static Mjpeg newInstance() {
        return new Mjpeg(Type.DEFAULT);
    }

    public static Mjpeg newInstance(Type type) {
        return new Mjpeg(type);
    }

    public Mjpeg credential(final String username, final String password) {
        if (username != null && password != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            });
        }
        return this;
    }

    public Observable<MjpegInputStream> open(String url) {
        return Observable.defer((Func0)Mjpeg$$Lambda$1.lambdaFactory$(this, url)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private /* synthetic */ Observable lambda$open$0(String string) {
        try {
            HttpURLConnection urlConnection = (HttpURLConnection)new URL(string).openConnection();
            InputStream inputStream = urlConnection.getInputStream();
            switch (this.type) {
                case DEFAULT: {
                    return Observable.just((Object)new MjpegInputStreamDefault(inputStream));
                }
                case NATIVE: {
                    return Observable.just((Object)new MjpegInputStreamNative(inputStream));
                }
            }
            throw new IllegalStateException("invalid type");
        }
        catch (IOException e) {
            return Observable.error((Throwable)e);
        }
    }

    static /* synthetic */ Observable access$lambda$0(Mjpeg mjpeg, String string) {
        return mjpeg.lambda$open$0(string);
    }

    public static enum Type {
        DEFAULT,
        NATIVE;

    }
}

