/*
 * Decompiled with CFR 0.152.
 */
package com.github.niqdev.mjpeg;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.StyleableRes;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.github.niqdev.mjpeg.AbstractMjpegView;
import com.github.niqdev.mjpeg.DisplayMode;
import com.github.niqdev.mjpeg.Mjpeg;
import com.github.niqdev.mjpeg.MjpegInputStream;
import com.github.niqdev.mjpeg.MjpegView;
import com.github.niqdev.mjpeg.MjpegViewDefault;
import com.github.niqdev.mjpeg.R;

public class IpCamMjpegView
extends SurfaceView
implements SurfaceHolder.Callback,
MjpegView {
    private MjpegView mMjpegView;
    private static final int DEFAULT_TYPE = 0;
    private static final SparseArray<Mjpeg.Type> TYPE = new SparseArray();

    public IpCamMjpegView(Context context, AttributeSet attrs) {
        super(context, attrs);
        switch (this.getPropertyType(attrs, R.styleable.IpCamMjpegView, R.styleable.IpCamMjpegView_type)) {
            case DEFAULT: {
                this.mMjpegView = new MjpegViewDefault(context, this, this);
                break;
            }
            case NATIVE: {
                throw new UnsupportedOperationException("not implemented");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mjpeg.Type getPropertyType(AttributeSet attributeSet, @StyleableRes int[] attrs, int attrIndex) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attributeSet, attrs, 0, 0);
        try {
            int typeIndex = typedArray.getInt(attrIndex, 0);
            Mjpeg.Type type = (Mjpeg.Type)((Object)TYPE.get(typeIndex));
            Mjpeg.Type type2 = type != null ? type : (Mjpeg.Type)((Object)TYPE.get(0));
            return type2;
        }
        finally {
            typedArray.recycle();
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        ((AbstractMjpegView)this.mMjpegView).onSurfaceCreated(holder);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        ((AbstractMjpegView)this.mMjpegView).onSurfaceChanged(holder, format, width, height);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        ((AbstractMjpegView)this.mMjpegView).onSurfaceDestroyed(holder);
    }

    @Override
    public void setSource(MjpegInputStream stream) {
        this.mMjpegView.setSource(stream);
    }

    @Override
    public void setDisplayMode(DisplayMode mode) {
        this.mMjpegView.setDisplayMode(mode);
    }

    @Override
    public void showFps(boolean show) {
        this.mMjpegView.showFps(show);
    }

    @Override
    public void stopPlayback() {
        this.mMjpegView.stopPlayback();
    }

    @Override
    public boolean isStreaming() {
        return this.mMjpegView.isStreaming();
    }

    @Override
    public void setResolution(int width, int height) {
        this.mMjpegView.setResolution(width, height);
    }

    @Override
    public void freeCameraMemory() {
        this.mMjpegView.freeCameraMemory();
    }

    static {
        TYPE.put(0, (Object)Mjpeg.Type.DEFAULT);
        TYPE.put(1, (Object)Mjpeg.Type.NATIVE);
    }
}

