/*
 * Decompiled with CFR 0.152.
 */
package qiu.niorgai;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import androidx.appcompat.widget.Toolbar;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.appbar.CollapsingToolbarLayout;
import java.lang.ref.WeakReference;

@TargetApi(value=21)
class StatusBarCompatLollipop {
    private static ValueAnimator sAnimator;

    StatusBarCompatLollipop() {
    }

    private static int getStatusBarHeight(Context context) {
        int result = 0;
        int resId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resId > 0) {
            result = context.getResources().getDimensionPixelOffset(resId);
        }
        return result;
    }

    static void setStatusBarColor(Activity activity, int statusColor) {
        Window window = activity.getWindow();
        window.clearFlags(0x4000000);
        window.addFlags(Integer.MIN_VALUE);
        window.setStatusBarColor(statusColor);
        window.getDecorView().setSystemUiVisibility(0);
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mChildView = mContentView.getChildAt(0);
        if (mChildView != null) {
            ViewCompat.setFitsSystemWindows((View)mChildView, (boolean)false);
            ViewCompat.requestApplyInsets((View)mChildView);
        }
    }

    static void translucentStatusBar(Activity activity, boolean hideStatusBarBackground) {
        Window window = activity.getWindow();
        window.addFlags(Integer.MIN_VALUE);
        if (hideStatusBarBackground) {
            window.clearFlags(0x4000000);
            window.setStatusBarColor(0);
            window.getDecorView().setSystemUiVisibility(1280);
        } else {
            window.addFlags(0x4000000);
            window.getDecorView().setSystemUiVisibility(0);
        }
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mChildView = mContentView.getChildAt(0);
        if (mChildView != null) {
            ViewCompat.setFitsSystemWindows((View)mChildView, (boolean)false);
            ViewCompat.requestApplyInsets((View)mChildView);
        }
    }

    static void setStatusBarColorForCollapsingToolbar(Activity activity, AppBarLayout appBarLayout, final CollapsingToolbarLayout collapsingToolbarLayout, Toolbar toolbar, final int statusColor) {
        CoordinatorLayout.Behavior behavior;
        Window window = activity.getWindow();
        window.clearFlags(0x4000000);
        window.addFlags(Integer.MIN_VALUE);
        window.setStatusBarColor(0);
        window.getDecorView().setSystemUiVisibility(0);
        ViewCompat.setOnApplyWindowInsetsListener((View)collapsingToolbarLayout, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                return insets;
            }
        });
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mChildView = mContentView.getChildAt(0);
        if (mChildView != null) {
            ViewCompat.setFitsSystemWindows((View)mChildView, (boolean)false);
            ViewCompat.requestApplyInsets((View)mChildView);
        }
        ((View)appBarLayout.getParent()).setFitsSystemWindows(false);
        appBarLayout.setFitsSystemWindows(false);
        toolbar.setFitsSystemWindows(false);
        if (toolbar.getTag() == null) {
            CollapsingToolbarLayout.LayoutParams lp = (CollapsingToolbarLayout.LayoutParams)toolbar.getLayoutParams();
            int statusBarHeight = StatusBarCompatLollipop.getStatusBarHeight((Context)activity);
            lp.height += statusBarHeight;
            toolbar.setLayoutParams((ViewGroup.LayoutParams)lp);
            toolbar.setPadding(toolbar.getPaddingLeft(), toolbar.getPaddingTop() + statusBarHeight, toolbar.getPaddingRight(), toolbar.getPaddingBottom());
            toolbar.setTag((Object)true);
        }
        if ((behavior = ((CoordinatorLayout.LayoutParams)appBarLayout.getLayoutParams()).getBehavior()) != null && behavior instanceof AppBarLayout.Behavior) {
            int verticalOffset = ((AppBarLayout.Behavior)behavior).getTopAndBottomOffset();
            if (Math.abs(verticalOffset) > appBarLayout.getHeight() - collapsingToolbarLayout.getScrimVisibleHeightTrigger()) {
                window.setStatusBarColor(statusColor);
            } else {
                window.setStatusBarColor(0);
            }
        } else {
            window.setStatusBarColor(0);
        }
        collapsingToolbarLayout.setFitsSystemWindows(false);
        final WeakReference<Window> windowWeakReference = new WeakReference<Window>(window);
        appBarLayout.addOnOffsetChangedListener(new AppBarLayout.OnOffsetChangedListener(){

            public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                Window weakWindow = (Window)windowWeakReference.get();
                if (weakWindow != null) {
                    if (Math.abs(verticalOffset) > appBarLayout.getHeight() - collapsingToolbarLayout.getScrimVisibleHeightTrigger()) {
                        if (weakWindow.getStatusBarColor() != statusColor) {
                            StatusBarCompatLollipop.startColorAnimation(weakWindow.getStatusBarColor(), statusColor, collapsingToolbarLayout.getScrimAnimationDuration(), windowWeakReference);
                        }
                    } else if (weakWindow.getStatusBarColor() != 0) {
                        StatusBarCompatLollipop.startColorAnimation(weakWindow.getStatusBarColor(), 0, collapsingToolbarLayout.getScrimAnimationDuration(), windowWeakReference);
                    }
                }
            }
        });
        collapsingToolbarLayout.getChildAt(0).setFitsSystemWindows(false);
        collapsingToolbarLayout.setStatusBarScrimColor(statusColor);
    }

    private static void startColorAnimation(int startColor, int endColor, long duration, final WeakReference<Window> windowWeakReference) {
        if (sAnimator != null) {
            sAnimator.cancel();
        }
        sAnimator = ValueAnimator.ofArgb((int[])new int[]{startColor, endColor}).setDuration(duration);
        sAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                Window window = (Window)windowWeakReference.get();
                if (window != null) {
                    window.setStatusBarColor(((Integer)valueAnimator.getAnimatedValue()).intValue());
                }
            }
        });
        sAnimator.start();
    }
}

