/*
 * Decompiled with CFR 0.152.
 */
package qiu.niorgai;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;

public class StatusBarCompat {
    private static final int COLOR_TRANSLUCENT = Color.parseColor((String)"#00000000");
    public static final int DEFAULT_COLOR_ALPHA = 112;

    public static void setStatusBarColor(Activity activity, int statusColor, int alpha) {
        StatusBarCompat.setStatusBarColor(activity, StatusBarCompat.calculateStatusBarColor(statusColor, alpha));
    }

    public static void setStatusBarColor(Activity activity, int statusColor) {
        Window window = activity.getWindow();
        ViewGroup mContentView = (ViewGroup)activity.findViewById(0x1020002);
        if (Build.VERSION.SDK_INT >= 19) {
            window.addFlags(0x4000000);
            if (Build.VERSION.SDK_INT >= 21) {
                window.clearFlags(0x4000000);
                window.addFlags(Integer.MIN_VALUE);
                window.setStatusBarColor(statusColor);
                View mChildView = mContentView.getChildAt(0);
                if (mChildView != null) {
                    ViewCompat.setFitsSystemWindows((View)mChildView, (boolean)true);
                }
            } else {
                ViewGroup mDecorView = (ViewGroup)window.getDecorView();
                if (mDecorView.getTag() != null && mDecorView.getTag() instanceof Boolean && ((Boolean)mDecorView.getTag()).booleanValue()) {
                    View mStatusBarView = mDecorView.getChildAt(0);
                    if (mStatusBarView != null) {
                        mStatusBarView.setBackgroundColor(statusColor);
                    }
                } else {
                    int statusBarHeight = StatusBarCompat.getStatusBarHeight((Context)activity);
                    View mContentChild = mContentView.getChildAt(0);
                    if (mContentChild != null) {
                        ViewCompat.setFitsSystemWindows((View)mContentChild, (boolean)false);
                        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)mContentChild.getLayoutParams();
                        lp.topMargin += statusBarHeight;
                        mContentChild.setLayoutParams((ViewGroup.LayoutParams)lp);
                    }
                    View mStatusBarView = new View((Context)activity);
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, statusBarHeight);
                    layoutParams.gravity = 48;
                    mStatusBarView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    mStatusBarView.setBackgroundColor(statusColor);
                    mDecorView.addView(mStatusBarView, 0);
                    mDecorView.setTag((Object)true);
                }
            }
        }
    }

    public static void translucentStatusBar(Activity activity) {
        StatusBarCompat.translucentStatusBar(activity, false);
    }

    public static void translucentStatusBar(Activity activity, boolean hideStatusBarBackground) {
        Window window = activity.getWindow();
        ViewGroup mContentView = (ViewGroup)activity.findViewById(0x1020002);
        View mChildView = mContentView.getChildAt(0);
        if (mChildView != null) {
            ViewCompat.setFitsSystemWindows((View)mChildView, (boolean)false);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            int statusBarHeight = StatusBarCompat.getStatusBarHeight((Context)activity);
            window.addFlags(0x4000000);
            if (Build.VERSION.SDK_INT >= 21) {
                window.addFlags(Integer.MIN_VALUE);
                if (hideStatusBarBackground) {
                    window.clearFlags(0x4000000);
                    window.setStatusBarColor(COLOR_TRANSLUCENT);
                } else {
                    window.setStatusBarColor(StatusBarCompat.calculateStatusBarColor(COLOR_TRANSLUCENT, 112));
                }
                if (mChildView != null) {
                    ViewCompat.requestApplyInsets((View)mChildView);
                }
            } else {
                ViewGroup mDecorView = (ViewGroup)window.getDecorView();
                if (mDecorView.getTag() != null && mDecorView.getTag() instanceof Boolean && ((Boolean)mDecorView.getTag()).booleanValue()) {
                    FrameLayout.LayoutParams lp;
                    mChildView = mDecorView.getChildAt(0);
                    mContentView.removeView(mChildView);
                    mChildView = mContentView.getChildAt(0);
                    if (mChildView != null && (lp = (FrameLayout.LayoutParams)mChildView.getLayoutParams()) != null && lp.topMargin >= statusBarHeight) {
                        lp.topMargin -= statusBarHeight;
                        mChildView.setLayoutParams((ViewGroup.LayoutParams)lp);
                    }
                    mDecorView.setTag((Object)false);
                }
            }
        }
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resId > 0) {
            result = context.getResources().getDimensionPixelOffset(resId);
        }
        return result;
    }

    private static int calculateStatusBarColor(int color, int alpha) {
        float a = 1.0f - (float)alpha / 255.0f;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = (int)((double)((float)red * a) + 0.5);
        green = (int)((double)((float)green * a) + 0.5);
        blue = (int)((double)((float)blue * a) + 0.5);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }
}

