/*
 * Decompiled with CFR 0.152.
 */
package co.nimblehq.recentapps.thumbnailhiding.navbar;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import co.nimblehq.recentapps.thumbnailhiding.navbar.OSUtils;
import co.nimblehq.recentapps.thumbnailhiding.navbar.OnNavigationBarListener;
import java.util.ArrayList;

public final class NavigationBarObserver
extends ContentObserver {
    static final String IMMERSION_MIUI_NAVIGATION_BAR_HIDE_SHOW = "force_fsg_nav_bar";
    static final String IMMERSION_EMUI_NAVIGATION_BAR_HIDE_SHOW = "navigationbar_is_min";
    private ArrayList<OnNavigationBarListener> mListeners;
    private Context activityContext;
    private Context context;
    private Boolean mIsRegister = false;

    public static NavigationBarObserver getInstance() {
        return NavigationBarObserverInstance.INSTANCE;
    }

    private NavigationBarObserver() {
        super(new Handler(Looper.getMainLooper()));
    }

    public void register(Context context) {
        this.activityContext = context;
        this.context = context.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 17 && context.getContentResolver() != null && !this.mIsRegister.booleanValue()) {
            Uri uri = null;
            if (OSUtils.isMIUI()) {
                uri = Settings.Global.getUriFor((String)IMMERSION_MIUI_NAVIGATION_BAR_HIDE_SHOW);
            } else if (OSUtils.isEMUI()) {
                uri = OSUtils.isEMUI3_x() || Build.VERSION.SDK_INT < 21 ? Settings.System.getUriFor((String)IMMERSION_EMUI_NAVIGATION_BAR_HIDE_SHOW) : Settings.Global.getUriFor((String)IMMERSION_EMUI_NAVIGATION_BAR_HIDE_SHOW);
            }
            if (uri != null) {
                context.getContentResolver().registerContentObserver(uri, true, (ContentObserver)this);
                this.mIsRegister = true;
            }
        }
    }

    public void unregister() {
        this.context.getContentResolver().unregisterContentObserver((ContentObserver)this);
    }

    public void onChange(boolean selfChange) {
        super.onChange(selfChange);
        if (this.mListeners != null && !this.mListeners.isEmpty()) {
            boolean enabled = NavigationBarObserver.isGestureEnabled(this.context);
            for (OnNavigationBarListener onNavigationBarListener : this.mListeners) {
                onNavigationBarListener.onNavigationBarChange(enabled);
            }
        }
    }

    public void addOnNavigationBarListener(OnNavigationBarListener listener) {
        if (listener == null) {
            return;
        }
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeOnNavigationBarListener(OnNavigationBarListener listener) {
        if (this.mIsRegister.booleanValue()) {
            this.context.getContentResolver().unregisterContentObserver((ContentObserver)this);
            this.mIsRegister = false;
        }
        this.context = null;
        if (listener == null || this.mListeners == null) {
            return;
        }
        this.mListeners.remove(listener);
    }

    public Context getActivityContext() {
        return this.activityContext;
    }

    public static boolean isAvailable() {
        return (OSUtils.isMIUI() || OSUtils.isEMUI()) && Build.VERSION.SDK_INT >= 17;
    }

    public static boolean isGestureEnabled(Context context) {
        int show = 0;
        Context appContext = context.getApplicationContext();
        if (NavigationBarObserver.isAvailable() && appContext != null && appContext.getContentResolver() != null) {
            if (OSUtils.isMIUI()) {
                show = Settings.Global.getInt((ContentResolver)appContext.getContentResolver(), (String)IMMERSION_MIUI_NAVIGATION_BAR_HIDE_SHOW, (int)0);
            } else if (OSUtils.isEMUI()) {
                show = OSUtils.isEMUI3_x() || Build.VERSION.SDK_INT < 21 ? Settings.System.getInt((ContentResolver)appContext.getContentResolver(), (String)IMMERSION_EMUI_NAVIGATION_BAR_HIDE_SHOW, (int)0) : Settings.Global.getInt((ContentResolver)appContext.getContentResolver(), (String)IMMERSION_EMUI_NAVIGATION_BAR_HIDE_SHOW, (int)0);
            }
        }
        return show != 0;
    }

    private static class NavigationBarObserverInstance {
        private static final NavigationBarObserver INSTANCE = new NavigationBarObserver();

        private NavigationBarObserverInstance() {
        }
    }
}

