/*
 * Decompiled with CFR 0.152.
 */
package com.github.nikartm.support;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.nikartm.support.StripedDrawable;
import com.github.nikartm.support.Util;

public class AnimatedStripedDrawable
extends Drawable {
    private int viewHeight;
    private int viewWidth;
    private float tiltLeft = 0.0f;
    private float tiltRight = 0.0f;
    private boolean running = false;
    private StripedDrawable drawable;
    private ValueAnimator animator;
    private Shader stripesShader;

    public AnimatedStripedDrawable(StripedDrawable drawable) {
        this.drawable = drawable;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.viewHeight = bounds.height();
        this.viewWidth = bounds.width();
        this.adjustStripes();
    }

    private void adjustStripes() {
        if (!this.drawable.isStripeRevert()) {
            this.tiltLeft = this.drawable.getTilt();
            this.tiltRight = 0.0f;
        } else {
            this.tiltRight = this.drawable.getTilt();
            this.tiltLeft = 0.0f;
        }
    }

    private void initAnimator() {
        if (this.animator == null) {
            this.animator = ValueAnimator.ofInt((int[])new int[]{0, 1});
            this.animator.setRepeatCount(-1);
            this.animator.setDuration((long)this.drawable.getStripeDuration());
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationRepeat(Animator animation) {
                    AnimatedStripedDrawable.this.shiftColor(AnimatedStripedDrawable.this.drawable.getColorMain(), AnimatedStripedDrawable.this.drawable.getColorSub());
                    AnimatedStripedDrawable.this.invalidateSelf();
                }
            });
        }
    }

    public int getIntrinsicWidth() {
        return this.viewWidth > 0 ? this.viewWidth : super.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.viewHeight > 0 ? this.viewHeight : super.getIntrinsicHeight();
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(@NonNull Canvas canvas) {
        this.drawStripes(canvas);
        this.startStripesAnimation();
    }

    private void startStripesAnimation() {
        if (this.running) {
            this.start();
        } else {
            this.drawable.setShowStripes(false);
        }
    }

    private void drawStripes(Canvas canvas) {
        Paint paintBack = new Paint(1);
        Paint paintStripes = new Paint(1);
        Rect rect = new Rect(0, 0, this.viewWidth, this.viewHeight);
        RectF rectF = new RectF(rect);
        int stripesAlpha = Util.computeAlpha(this.drawable.getStripeAlpha());
        this.stripesShader = this.drawable.isStripeGradient() ? this.createGradientShader() : this.createShader();
        paintBack.setColor(this.drawable.getColorBack());
        float cornerRadius = this.drawable.getCornerRadius();
        canvas.drawRoundRect(rectF, cornerRadius, cornerRadius, paintBack);
        if (this.drawable.isShowStripes()) {
            paintStripes.setAlpha(stripesAlpha);
            paintStripes.setShader(this.stripesShader);
            canvas.drawRoundRect(rectF, cornerRadius, cornerRadius, paintStripes);
        }
    }

    @NonNull
    private LinearGradient createShader() {
        return new LinearGradient(this.drawable.getStripeWidth(), this.tiltLeft, 0.0f, this.tiltRight, new int[]{this.drawable.getColorMain(), this.drawable.getColorSub()}, new float[]{0.5f, 0.5f}, Shader.TileMode.REPEAT);
    }

    @NonNull
    private LinearGradient createGradientShader() {
        return new LinearGradient(this.drawable.getStripeWidth(), this.tiltLeft, 0.0f, this.tiltRight, this.drawable.getColorMain(), this.drawable.getColorSub(), Shader.TileMode.REPEAT);
    }

    private void shiftColor(int mainColor, int subColor) {
        this.drawable.setColorMain(subColor);
        this.drawable.setColorSub(mainColor);
    }

    protected void start() {
        if (this.isRunning()) {
            return;
        }
        this.running = true;
        this.initAnimator();
        this.animator.start();
        this.drawable.setShowStripes(true);
        this.invalidateSelf();
    }

    protected void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.running = false;
        this.animator.cancel();
        this.drawable.setShowStripes(false);
        this.invalidateSelf();
    }

    protected boolean isRunning() {
        return this.animator != null && this.animator.isStarted();
    }
}

