/*
 * Decompiled with CFR 0.152.
 */
package ru.nikartm.support;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.view.View;
import ru.nikartm.support.BadgePosition;
import ru.nikartm.support.model.Badge;

public class BadgeDrawer {
    private BadgePosition position;
    private Paint paint;
    private View view;
    private Badge badge;

    BadgeDrawer(View view, Badge badge) {
        this.view = view;
        this.badge = badge;
    }

    public void draw(Canvas canvas) {
        if (this.badge.isVisible() || this.badge.getValue() > 0) {
            this.initPaint();
            this.computeTextWidth();
            this.position = new BadgePosition(this.view, this.badge).compute();
            this.drawBadge(canvas);
            if (this.badge.isShowCounter()) {
                this.drawText(canvas);
            }
        }
    }

    private void initPaint() {
        if (this.paint == null) {
            this.paint = new Paint();
            this.paint.setAntiAlias(true);
            Typeface typeface = Typeface.create((Typeface)this.badge.getBadgeTextFont(), (int)this.badge.getTextStyle());
            this.paint.setTypeface(typeface);
            this.paint.setTextSize(this.badge.getBadgeTextSize());
        }
    }

    private void drawBadge(Canvas canvas) {
        this.paint.setColor(this.badge.getBadgeColor());
        if (this.badge.getBackgroundDrawable() != null) {
            this.badge.getBackgroundDrawable().setBounds(0, 0, this.position.getBadgeWidth(), this.position.getBadgeHeight());
            canvas.save();
            canvas.translate(this.position.getDeltaX() - (float)(this.position.getBadgeWidth() / 2), this.position.getDeltaY() - (float)(this.position.getBadgeHeight() / 2));
            this.badge.getBackgroundDrawable().draw(canvas);
            canvas.restore();
        } else {
            canvas.drawCircle(this.position.getDeltaX(), this.position.getDeltaY(), this.badge.getRadius(), this.paint);
        }
    }

    private void drawText(Canvas canvas) {
        this.paint.setColor(this.badge.getBadgeTextColor());
        if (this.badge.isLimitValue() && this.badge.getValue() > this.badge.getMaxValue()) {
            canvas.drawText(String.valueOf(this.badge.getMaxValue()).concat("+"), this.position.getDeltaX() - this.badge.getTextWidth() / 2.0f, this.position.getDeltaY() + this.badge.getBadgeTextSize() / 3.0f, this.paint);
        } else {
            canvas.drawText(String.valueOf(this.badge.getValue()), this.position.getDeltaX() - this.badge.getTextWidth() / 2.0f, this.position.getDeltaY() + this.badge.getBadgeTextSize() / 3.0f, this.paint);
        }
    }

    private void computeTextWidth() {
        float textWidth = this.badge.isLimitValue() && this.badge.getValue() > this.badge.getMaxValue() ? this.paint.measureText(String.valueOf(this.badge.getMaxValue()).concat("+")) : this.paint.measureText(String.valueOf(this.badge.getValue()));
        this.badge.setTextWidth(textWidth);
    }
}

