/*
 * Decompiled with CFR 0.152.
 */
package ru.nikartm.support;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;
import ru.nikartm.support.DrawerManager;
import ru.nikartm.support.listener.OnBadgeCountChangeListener;
import ru.nikartm.support.util.DensityUtils;

public class ImageBadgeView
extends AppCompatImageView {
    private DrawerManager manager;
    private OnBadgeCountChangeListener onBadgeCountChangeListener;

    public ImageBadgeView(Context context) {
        super(context);
        this.initAttr(null);
    }

    public ImageBadgeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttr(attrs);
    }

    public ImageBadgeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttr(attrs);
    }

    private void initAttr(AttributeSet attrs) {
        this.manager = new DrawerManager((View)this, attrs);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.manager.drawBadge(canvas);
    }

    public void setOnBadgeCountChangeListener(OnBadgeCountChangeListener listener) {
        this.onBadgeCountChangeListener = listener;
    }

    public int getBadgeValue() {
        return this.manager.getBadge().getValue();
    }

    public ImageBadgeView setBadgeValue(int badgeValue) {
        this.manager.getBadge().setValue(badgeValue);
        if (this.onBadgeCountChangeListener != null) {
            this.onBadgeCountChangeListener.onCountChange(badgeValue);
        }
        this.invalidate();
        return this;
    }

    public int getMaxBadgeValue() {
        return this.manager.getBadge().getMaxValue();
    }

    public ImageBadgeView setMaxBadgeValue(int maxBadgeValue) {
        this.manager.getBadge().setMaxValue(maxBadgeValue);
        this.invalidate();
        return this;
    }

    public boolean isVisibleBadge() {
        return this.manager.getBadge().isVisible();
    }

    public ImageBadgeView visibleBadge(boolean visible) {
        this.manager.getBadge().setVisible(visible);
        this.invalidate();
        return this;
    }

    public boolean isRoundBadge() {
        return this.manager.getBadge().isRoundBadge();
    }

    public ImageBadgeView setRoundBadge(boolean roundBadge) {
        this.manager.getBadge().setRoundBadge(roundBadge);
        this.invalidate();
        return this;
    }

    public boolean isFixedRadius() {
        return this.manager.getBadge().isFixedRadius();
    }

    public ImageBadgeView setFixedRadius(boolean fixedRadius) {
        this.manager.getBadge().setFixedRadius(fixedRadius);
        this.invalidate();
        return this;
    }

    public boolean isBadgeOvalAfterFirst() {
        return this.manager.getBadge().isOvalAfterFirst();
    }

    public ImageBadgeView setBadgeOvalAfterFirst(boolean badgeOvalAfterFirst) {
        this.manager.getBadge().setOvalAfterFirst(badgeOvalAfterFirst);
        this.invalidate();
        return this;
    }

    public boolean isShowCounter() {
        return this.manager.getBadge().isShowCounter();
    }

    public ImageBadgeView setShowCounter(boolean showCounter) {
        this.manager.getBadge().setShowCounter(showCounter);
        this.invalidate();
        return this;
    }

    public boolean isLimitValue() {
        return this.manager.getBadge().isLimitValue();
    }

    public ImageBadgeView setLimitBadgeValue(boolean badgeValueLimit) {
        this.manager.getBadge().setLimitValue(badgeValueLimit);
        this.invalidate();
        return this;
    }

    public int getBadgeColor() {
        return this.manager.getBadge().getBadgeColor();
    }

    public ImageBadgeView setBadgeColor(int badgeColor) {
        this.manager.getBadge().setBadgeColor(badgeColor);
        this.invalidate();
        return this;
    }

    public int getBadgeTextColor() {
        return this.manager.getBadge().getBadgeTextColor();
    }

    public ImageBadgeView setBadgeTextColor(int badgeTextColor) {
        this.manager.getBadge().setBadgeTextColor(badgeTextColor);
        this.invalidate();
        return this;
    }

    public float getBadgeTextSize() {
        return this.manager.getBadge().getBadgeTextSize();
    }

    public ImageBadgeView setBadgeTextSize(float badgeTextSize) {
        this.manager.getBadge().setBadgeTextSize(DensityUtils.dpToPx(badgeTextSize));
        this.invalidate();
        return this;
    }

    public float getBadgePadding() {
        return this.manager.getBadge().getPadding();
    }

    public ImageBadgeView setBadgePadding(int badgePadding) {
        this.manager.getBadge().setPadding(DensityUtils.txtPxToSp(badgePadding));
        this.invalidate();
        return this;
    }

    public float getBadgeRadius() {
        return this.manager.getBadge().getRadius();
    }

    public ImageBadgeView setFixedBadgeRadius(float fixedBadgeRadius) {
        this.manager.getBadge().setFixedRadiusSize(fixedBadgeRadius);
        this.invalidate();
        return this;
    }

    public Typeface getBadgeTextFont() {
        return this.manager.getBadge().getBadgeTextFont();
    }

    public ImageBadgeView setBadgeTextFont(Typeface font) {
        this.manager.getBadge().setBadgeTextFont(font);
        this.invalidate();
        return this;
    }

    public int getBadgeTextStyle() {
        return this.manager.getBadge().getTextStyle();
    }

    public ImageBadgeView setBadgeTextStyle(int badgeTextStyle) {
        this.manager.getBadge().setTextStyle(badgeTextStyle);
        this.invalidate();
        return this;
    }

    public int getBadgeBackground() {
        return this.manager.getBadge().getBadgeBackground();
    }

    public Drawable getBadgeBackgroundDrawable() {
        return this.manager.getBadge().getBackgroundDrawable();
    }

    public ImageBadgeView setBadgeBackground(Drawable badgeBackground) {
        this.manager.getBadge().setBackgroundDrawable(badgeBackground);
        this.invalidate();
        return this;
    }

    public void clearBadge() {
        this.manager.getBadge().clearValue();
        this.invalidate();
    }

    public int getBadgePosition() {
        return this.manager.getBadge().getPosition();
    }

    public ImageBadgeView setBadgePosition(int position) {
        this.manager.getBadge().setPosition(position);
        this.invalidate();
        return this;
    }
}

