/*
 * Decompiled with CFR 0.152.
 */
package ru.nikartm.support;

import android.view.View;
import ru.nikartm.support.model.Badge;

public class BadgePosition {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    public static final int CENTER = 4;
    private View view;
    private Badge badge;
    private boolean isDrawBackgroundAdded = false;
    private float pivotX;
    private float pivotY;
    private int viewHeight;
    private int viewWidth;
    private int badgeWidth;
    private int badgeHeight;
    private float deltaX;
    private float deltaY;

    BadgePosition(View view, Badge badge) {
        this.view = view;
        this.badge = badge;
        this.computeBadgeWidth();
        this.computeBadgeHeight();
        this.computeRadius();
        this.init();
    }

    private void init() {
        this.isDrawBackgroundAdded = this.badge.getBackgroundDrawable() != null;
        this.pivotX = this.view.getPivotX();
        this.pivotY = this.view.getPivotY();
        this.viewHeight = this.view.getMeasuredHeight();
        this.viewWidth = this.view.getMeasuredWidth();
    }

    public BadgePosition compute() {
        switch (this.badge.getPosition()) {
            case 0: {
                this.computeTopLeft();
                break;
            }
            case 1: {
                this.computeTopRight();
                break;
            }
            case 2: {
                this.computeBottomLeft();
                break;
            }
            case 3: {
                this.computeBottomRight();
                break;
            }
            case 4: {
                this.computeCenter();
            }
        }
        return this;
    }

    private void computeTopLeft() {
        this.deltaX = this.pivotX - (float)(this.viewWidth / 2) + this.badge.getRadius();
        this.deltaY = this.pivotY - (float)(this.viewHeight / 2) + this.badge.getRadius();
        if (this.isDrawBackgroundAdded) {
            if (this.badge.isFixedRadius()) {
                int maxRadius;
                if (this.badgeWidth > this.badgeHeight) {
                    this.deltaX = this.pivotX - (float)(this.viewWidth / 2) + (float)(this.getBadgeWidth() / 2);
                    this.deltaY = this.pivotY - (float)(this.viewHeight / 2) + (float)(this.getBadgeWidth() / 2);
                } else {
                    this.deltaX = this.pivotX - (float)(this.viewWidth / 2) + (float)(this.getBadgeHeight() / 2);
                    this.deltaY = this.pivotY - (float)(this.viewHeight / 2) + (float)(this.getBadgeHeight() / 2);
                }
                this.badgeWidth = maxRadius = Math.max(this.badgeWidth, this.badgeHeight);
                this.badgeHeight = maxRadius;
            } else if (this.badge.isRoundBadge() && this.badgeWidth < this.badgeHeight) {
                this.deltaX = this.pivotX - (float)(this.viewWidth / 2) + (float)(this.getBadgeHeight() / 2);
                this.deltaY = this.pivotY - (float)(this.viewHeight / 2) + (float)(this.getBadgeHeight() / 2);
                this.badgeWidth = this.badgeHeight;
            }
        }
    }

    private void computeTopRight() {
        this.deltaX = this.pivotX + (float)(this.viewWidth / 2) - this.badge.getRadius();
        this.deltaY = this.pivotY - (float)(this.viewHeight / 2) + this.badge.getRadius();
        if (this.isDrawBackgroundAdded) {
            if (this.badge.isFixedRadius()) {
                int maxRadius;
                if (this.badgeWidth > this.badgeHeight) {
                    this.deltaX = this.pivotX + (float)(this.viewWidth / 2) - (float)(this.getBadgeWidth() / 2);
                    this.deltaY = this.pivotY - (float)(this.viewHeight / 2) + (float)(this.getBadgeWidth() / 2);
                } else {
                    this.deltaX = this.pivotX + (float)(this.viewWidth / 2) - (float)(this.getBadgeHeight() / 2);
                    this.deltaY = this.pivotY - (float)(this.viewHeight / 2) + (float)(this.getBadgeHeight() / 2);
                }
                this.badgeWidth = maxRadius = Math.max(this.badgeWidth, this.badgeHeight);
                this.badgeHeight = maxRadius;
            } else if (this.badge.isRoundBadge() && this.badgeWidth < this.badgeHeight) {
                this.deltaX = this.pivotX + (float)(this.viewWidth / 2) - (float)(this.getBadgeHeight() / 2);
                this.deltaY = this.pivotY - (float)(this.viewHeight / 2) + (float)(this.getBadgeHeight() / 2);
                this.badgeWidth = this.badgeHeight;
            }
        }
    }

    private void computeBottomLeft() {
        this.deltaX = this.pivotX - (float)(this.viewWidth / 2) + this.badge.getRadius();
        this.deltaY = this.pivotY + (float)(this.viewHeight / 2) - this.badge.getRadius();
        if (this.isDrawBackgroundAdded) {
            if (this.badge.isFixedRadius()) {
                int maxRadius;
                if (this.badgeWidth > this.badgeHeight) {
                    this.deltaX = this.pivotX - (float)(this.viewWidth / 2) + (float)(this.getBadgeWidth() / 2);
                    this.deltaY = this.pivotY + (float)(this.viewHeight / 2) - (float)(this.getBadgeWidth() / 2);
                } else {
                    this.deltaX = this.pivotX - (float)(this.viewWidth / 2) + (float)(this.getBadgeHeight() / 2);
                    this.deltaY = this.pivotY + (float)(this.viewHeight / 2) - (float)(this.getBadgeHeight() / 2);
                }
                this.badgeWidth = maxRadius = Math.max(this.badgeWidth, this.badgeHeight);
                this.badgeHeight = maxRadius;
            } else if (this.badge.isRoundBadge() && this.badgeWidth < this.badgeHeight) {
                this.deltaX = this.pivotX - (float)(this.viewWidth / 2) + (float)(this.getBadgeHeight() / 2);
                this.deltaY = this.pivotY + (float)(this.viewHeight / 2) - (float)(this.getBadgeHeight() / 2);
                this.badgeWidth = this.badgeHeight;
            }
        }
    }

    private void computeBottomRight() {
        this.deltaX = this.pivotX + (float)(this.viewWidth / 2) - this.badge.getRadius();
        this.deltaY = this.pivotY + (float)(this.viewHeight / 2) - this.badge.getRadius();
        if (this.isDrawBackgroundAdded) {
            if (this.badge.isFixedRadius()) {
                int maxRadius;
                if (this.badgeWidth > this.badgeHeight) {
                    this.deltaX = this.pivotX + (float)(this.viewWidth / 2) - (float)(this.getBadgeWidth() / 2);
                    this.deltaY = this.pivotY + (float)(this.viewHeight / 2) - (float)(this.getBadgeWidth() / 2);
                } else {
                    this.deltaX = this.pivotX + (float)(this.viewWidth / 2) - (float)(this.getBadgeHeight() / 2);
                    this.deltaY = this.pivotY + (float)(this.viewHeight / 2) - (float)(this.getBadgeHeight() / 2);
                }
                this.badgeWidth = maxRadius = Math.max(this.badgeWidth, this.badgeHeight);
                this.badgeHeight = maxRadius;
            } else if (this.badge.isRoundBadge() && this.badgeWidth < this.badgeHeight) {
                this.deltaX = this.pivotX + (float)(this.viewWidth / 2) - (float)(this.getBadgeHeight() / 2);
                this.deltaY = this.pivotY + (float)(this.viewHeight / 2) - (float)(this.getBadgeHeight() / 2);
                this.badgeWidth = this.badgeHeight;
            }
        }
    }

    private void computeCenter() {
        this.deltaX = this.viewWidth / 2;
        this.deltaY = this.viewHeight / 2;
        if (this.isDrawBackgroundAdded) {
            if (this.badge.isFixedRadius()) {
                int fixedDiameter;
                this.badgeWidth = fixedDiameter = (int)this.badge.getFixedRadiusSize() * 2;
                this.badgeHeight = fixedDiameter;
            } else if (this.badge.isRoundBadge() && this.badgeWidth < this.badgeHeight) {
                this.badgeWidth = this.badgeHeight;
            }
        }
    }

    private void computeBadgeWidth() {
        this.badgeWidth = this.badge.getBackgroundDrawable() != null && this.badge.getValue() > 9 && this.badge.isOvalAfterFirst() && !this.badge.isFixedRadius() ? (int)(this.badge.getTextWidth() + this.badge.getPadding() * 4.0f) : (int)(this.badge.getTextWidth() + this.badge.getPadding() * 2.0f);
    }

    private void computeBadgeHeight() {
        this.badgeHeight = (int)(this.badge.getBadgeTextSize() + this.badge.getPadding() * 2.0f);
    }

    private void computeRadius() {
        if (this.badge.getFixedRadiusSize() != -1.0f) {
            this.badge.setRadius(this.badge.getFixedRadiusSize());
        } else {
            this.badge.setRadius(this.badgeWidth / 2);
        }
    }

    public int getBadgeHeight() {
        return this.badgeHeight;
    }

    public int getBadgeWidth() {
        return this.badgeWidth;
    }

    public float getDeltaX() {
        return this.deltaX;
    }

    public float getDeltaY() {
        return this.deltaY;
    }
}

