/*
 * Decompiled with CFR 0.152.
 */
package com.holdenkarau.spark.testing;

import com.holdenkarau.spark.testing.DataFrameSuiteBase$;
import com.holdenkarau.spark.testing.DataFrameSuiteBaseLike;
import com.holdenkarau.spark.testing.SparkSessionProvider$;
import com.holdenkarau.spark.testing.Utils$;
import com.holdenkarau.spark.testing.WrappedConfVar;
import java.io.File;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class DataFrameSuiteBaseLike$class {
    public static SparkSession spark(DataFrameSuiteBaseLike $this) {
        return SparkSessionProvider$.MODULE$._sparkSession();
    }

    public static SQLContext sqlContext(DataFrameSuiteBaseLike $this) {
        return SparkSessionProvider$.MODULE$.sqlContext();
    }

    public static SQLContext impSqlContext(DataFrameSuiteBaseLike $this) {
        return $this.sqlContext();
    }

    public static boolean enableHiveSupport(DataFrameSuiteBaseLike $this) {
        return true;
    }

    public static void sqlBeforeAllTestCases(DataFrameSuiteBaseLike $this) {
        if (SparkSessionProvider$.MODULE$._sparkSession() == null || SparkSessionProvider$.MODULE$._sparkSession().sparkContext().isStopped()) {
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1());
            String localMetastorePath = new File(tempDir, "metastore").getCanonicalPath();
            String localWarehousePath = new File(tempDir, "wharehouse").getCanonicalPath();
            SparkSession.Builder builder = DataFrameSuiteBaseLike$class.newBuilder$1($this, localMetastorePath, localWarehousePath);
            SparkSessionProvider$.MODULE$._sparkSession_$eq(builder.getOrCreate());
        }
    }

    public static void assertDataFrameEquals(DataFrameSuiteBaseLike $this, Dataset expected, Dataset result) {
        $this.assertDataFrameApproximateEquals((Dataset<Row>)expected, (Dataset<Row>)result, 0.0, $this.assertDataFrameApproximateEquals$default$4());
    }

    public static void assertDataFrameApproximateEquals(DataFrameSuiteBaseLike $this, Dataset expected, Dataset result, double tol, double relTol) {
        $this.assert(expected.schema(), result.schema(), ClassTag$.MODULE$.apply(StructType.class));
        try {
            expected.rdd().cache();
            result.rdd().cache();
            $this.assert("Length not Equal", BoxesRunTime.boxToLong((long)expected.rdd().count()), BoxesRunTime.boxToLong((long)result.rdd().count()), ClassTag$.MODULE$.Long());
            RDD expectedIndexValue = $this.zipWithIndex(expected.rdd());
            RDD resultIndexValue = $this.zipWithIndex(result.rdd());
            RDD unequalRDD = RDD$.MODULE$.rddToPairRDDFunctions(expectedIndexValue, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Row.class), (Ordering)Ordering.Long$.MODULE$).join(resultIndexValue).filter((Function1)new Serializable($this, tol, relTol){
                public static final long serialVersionUID = 0L;
                private final double tol$2;
                private final double relTol$1;

                public final boolean apply(Tuple2<Object, Tuple2<Row, Row>> x0$2) {
                    Tuple2 tuple2;
                    Tuple2<Object, Tuple2<Row, Row>> tuple22 = x0$2;
                    if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                        Row r2;
                        Row r1 = (Row)tuple2._1();
                        boolean bl = !r1.equals((Object)(r2 = (Row)tuple2._2())) && !DataFrameSuiteBase$.MODULE$.approxEquals(r1, r2, this.tol$2, this.relTol$1);
                        return bl;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    this.tol$2 = tol$2;
                    this.relTol$1 = relTol$1;
                }
            });
            $this.assertEmpty(unequalRDD.take($this.maxUnequalRowsToShow()), ClassTag$.MODULE$.apply(Tuple2.class));
            return;
        }
        finally {
            expected.rdd().unpersist(expected.rdd().unpersist$default$1());
            result.rdd().unpersist(result.rdd().unpersist$default$1());
        }
    }

    public static double assertDataFrameApproximateEquals$default$3(DataFrameSuiteBaseLike $this) {
        return 0.0;
    }

    public static double assertDataFrameApproximateEquals$default$4(DataFrameSuiteBaseLike $this) {
        return 0.0;
    }

    public static RDD zipWithIndex(DataFrameSuiteBaseLike $this, RDD rdd) {
        return rdd.zipWithIndex().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, U> apply(Tuple2<U, Object> x0$1) {
                Tuple2<U, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Object row = tuple2._1();
                    long idx = tuple2._2$mcJ$sp();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)idx), row);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static boolean approxEquals(DataFrameSuiteBaseLike $this, Row r1, Row r2, double tol, double relTol) {
        return DataFrameSuiteBase$.MODULE$.approxEquals(r1, r2, tol, relTol);
    }

    public static double approxEquals$default$3(DataFrameSuiteBaseLike $this) {
        return 0.0;
    }

    public static double approxEquals$default$4(DataFrameSuiteBaseLike $this) {
        return 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private static final SparkSession.Builder newBuilder$1(DataFrameSuiteBaseLike $this, String localMetastorePath$1, String localWarehousePath$1) {
        void var3_3;
        Object object;
        BoxedUnit boxedUnit;
        SparkSession.Builder builder = SparkSession$.MODULE$.builder();
        builder.config("spark.io.compression.codec", "snappy");
        if ($this.enableHiveSupport()) {
            HiveConf.ConfVars[] hiveConfVars = HiveConf.ConfVars.values();
            WrappedConfVar[] accessiableHiveConfVars = (WrappedConfVar[])Predef$.MODULE$.refArrayOps((Object[])hiveConfVars).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final WrappedConfVar apply(HiveConf.ConfVars x$1) {
                    return new WrappedConfVar(x$1);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WrappedConfVar.class)));
            Predef$.MODULE$.refArrayOps((Object[])accessiableHiveConfVars).foreach((Function1)new Serializable($this, builder){
                public static final long serialVersionUID = 0L;
                private final SparkSession.Builder builder$1;

                public final Object apply(WrappedConfVar confvar) {
                    return confvar.varname().contains("datanucleus") || confvar.varname().contains("jdo") ? this.builder$1.config(confvar.varname(), confvar.getDefaultExpr()) : BoxedUnit.UNIT;
                }
                {
                    this.builder$1 = builder$1;
                }
            });
            boxedUnit = builder.config(HiveConf.ConfVars.METASTOREURIS.varname, "");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        builder.config("javax.jdo.option.ConnectionURL", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdbc:derby:;databaseName=", ";create=true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{localMetastorePath$1})));
        builder.config("datanucleus.rdbms.datastoreAdapterClassName", "org.datanucleus.store.rdbms.adapter.DerbyAdapter");
        builder.config("spark.sql.streaming.checkpointLocation", ((Object)Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1()).toPath()).toString());
        builder.config("spark.sql.warehouse.dir", localWarehousePath$1);
        try {
            object = $this.enableHiveSupport() ? builder.enableHiveSupport() : BoxedUnit.UNIT;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    public static void $init$(DataFrameSuiteBaseLike $this) {
        $this.com$holdenkarau$spark$testing$DataFrameSuiteBaseLike$_setter_$maxUnequalRowsToShow_$eq(10);
    }
}

