/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventServiceExistsException;
import org.bushe.swing.event.EventServiceLocator;
import org.bushe.swing.event.Logger;
import org.bushe.swing.event.VetoTopicEventListener;
import org.bushe.swing.event.annotation.BaseProxySubscriber;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.bushe.swing.event.annotation.EventTopicPatternSubscriber;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import org.bushe.swing.event.annotation.ProxyTopicPatternSubscriber;
import org.bushe.swing.event.annotation.ProxyTopicSubscriber;
import org.bushe.swing.event.annotation.ReferenceStrength;
import org.bushe.swing.event.annotation.RuntimeTopicEventSubscriber;
import org.bushe.swing.event.annotation.RuntimeTopicPatternEventSubscriber;
import org.bushe.swing.event.annotation.UseTheClassOfTheAnnotatedMethodsParameter;
import org.bushe.swing.event.annotation.VetoRuntimeTopicPatternSubscriber;
import org.bushe.swing.event.annotation.VetoRuntimeTopicSubscriber;
import org.bushe.swing.event.annotation.VetoSubscriber;
import org.bushe.swing.event.annotation.VetoTopicPatternSubscriber;
import org.bushe.swing.event.annotation.VetoTopicSubscriber;

public class AnnotationProcessor {
    protected static final Logger LOG = Logger.getLogger(EventService.class.getName());

    public static void process(Object obj) {
        AnnotationProcessor.processOrUnprocess(obj, true);
    }

    public static void unprocess(Object obj) {
        AnnotationProcessor.processOrUnprocess(obj, false);
    }

    private static void processOrUnprocess(Object obj, boolean add) {
        if (obj == null) {
            return;
        }
        Class<?> cl = obj.getClass();
        Object[] methods = cl.getMethods();
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Looking for EventBus annotations for class " + cl + ", methods:" + Arrays.toString(methods));
        }
        for (Object method : methods) {
            VetoRuntimeTopicPatternSubscriber vetoAnnotation;
            VetoRuntimeTopicSubscriber vetoRuntimeTopicAnnotation;
            VetoTopicPatternSubscriber vetoTopicPatternAnnotation;
            VetoTopicSubscriber vetoTopicAnnotation;
            VetoSubscriber vetoClassAnnotation;
            RuntimeTopicPatternEventSubscriber annotation;
            RuntimeTopicEventSubscriber runtimeTopicAnnotation;
            EventTopicPatternSubscriber topicPatternAnnotation;
            EventTopicSubscriber topicAnnotation;
            EventSubscriber classAnnotation = ((Method)method).getAnnotation(EventSubscriber.class);
            if (classAnnotation != null) {
                if (LOG.isLoggable(Logger.Level.DEBUG)) {
                    LOG.debug("Found EventSubscriber:" + classAnnotation + " on method:" + method);
                }
                AnnotationProcessor.process(classAnnotation, obj, (Method)method, add);
            }
            if ((topicAnnotation = ((Method)method).getAnnotation(EventTopicSubscriber.class)) != null) {
                if (LOG.isLoggable(Logger.Level.DEBUG)) {
                    LOG.debug("Found EventTopicSubscriber: " + topicAnnotation + "  on method:" + method);
                }
                AnnotationProcessor.process(topicAnnotation, obj, (Method)method, add);
            }
            if ((topicPatternAnnotation = ((Method)method).getAnnotation(EventTopicPatternSubscriber.class)) != null) {
                if (LOG.isLoggable(Logger.Level.DEBUG)) {
                    LOG.debug("Found EventTopicPatternSubscriber: " + topicPatternAnnotation + " on method:" + method);
                }
                AnnotationProcessor.process(topicPatternAnnotation, obj, (Method)method, add);
            }
            if ((runtimeTopicAnnotation = ((Method)method).getAnnotation(RuntimeTopicEventSubscriber.class)) != null) {
                if (LOG.isLoggable(Logger.Level.DEBUG)) {
                    LOG.debug("Found RuntimeTopicEventSubscriber: " + runtimeTopicAnnotation + " on method:" + method);
                }
                AnnotationProcessor.process(runtimeTopicAnnotation, obj, (Method)method, add);
            }
            if ((annotation = ((Method)method).getAnnotation(RuntimeTopicPatternEventSubscriber.class)) != null) {
                if (LOG.isLoggable(Logger.Level.DEBUG)) {
                    LOG.debug("Found RuntimeTopicPatternEventSubscriber:" + annotation + " on method:" + method);
                }
                AnnotationProcessor.process(annotation, obj, (Method)method, add);
            }
            if ((vetoClassAnnotation = ((Method)method).getAnnotation(VetoSubscriber.class)) != null) {
                if (LOG.isLoggable(Logger.Level.DEBUG)) {
                    LOG.debug("Found VetoSubscriber:" + vetoClassAnnotation + " on method:" + method);
                }
                AnnotationProcessor.process(vetoClassAnnotation, obj, (Method)method, add);
            }
            if ((vetoTopicAnnotation = ((Method)method).getAnnotation(VetoTopicSubscriber.class)) != null) {
                if (LOG.isLoggable(Logger.Level.DEBUG)) {
                    LOG.debug("Found VetoTopicSubscriber: " + vetoTopicAnnotation + "  on method:" + method);
                }
                AnnotationProcessor.process(vetoTopicAnnotation, obj, (Method)method, add);
            }
            if ((vetoTopicPatternAnnotation = ((Method)method).getAnnotation(VetoTopicPatternSubscriber.class)) != null) {
                if (LOG.isLoggable(Logger.Level.DEBUG)) {
                    LOG.debug("Found VetoTopicPatternSubscriber: " + vetoTopicPatternAnnotation + " on method:" + method);
                }
                AnnotationProcessor.process(vetoTopicPatternAnnotation, obj, (Method)method, add);
            }
            if ((vetoRuntimeTopicAnnotation = ((Method)method).getAnnotation(VetoRuntimeTopicSubscriber.class)) != null) {
                if (LOG.isLoggable(Logger.Level.DEBUG)) {
                    LOG.debug("Found VetoRuntimeTopicSubscriber: " + vetoRuntimeTopicAnnotation + " on method:" + method);
                }
                AnnotationProcessor.process(vetoRuntimeTopicAnnotation, obj, (Method)method, add);
            }
            if ((vetoAnnotation = ((Method)method).getAnnotation(VetoRuntimeTopicPatternSubscriber.class)) == null) continue;
            if (LOG.isLoggable(Logger.Level.DEBUG)) {
                LOG.debug("Found VetoRuntimeTopicPatternSubscriber:" + vetoAnnotation + " on method:" + method);
            }
            AnnotationProcessor.process(vetoAnnotation, obj, (Method)method, add);
        }
    }

    private static void process(EventTopicPatternSubscriber topicPatternAnnotation, Object obj, Method method, boolean add) {
        String topicPattern = topicPatternAnnotation.topicPattern();
        if (topicPattern == null) {
            throw new IllegalArgumentException("Topic pattern cannot be null for EventTopicPatternSubscriber annotation");
        }
        Class<? extends EventService> eventServiceClass = topicPatternAnnotation.autoCreateEventServiceClass();
        String eventServiceName = topicPatternAnnotation.eventServiceName();
        EventService eventService = AnnotationProcessor.getEventServiceFromAnnotation(eventServiceName, eventServiceClass);
        int priority = topicPatternAnnotation.priority();
        Pattern pattern = Pattern.compile(topicPattern);
        if (add) {
            ProxyTopicPatternSubscriber subscriber = new ProxyTopicPatternSubscriber(obj, method, topicPatternAnnotation.referenceStrength(), priority, eventService, topicPattern, pattern, false);
            eventService.subscribeStrongly(pattern, (org.bushe.swing.event.EventTopicSubscriber)subscriber);
        } else {
            eventService.unsubscribe(pattern, obj);
        }
    }

    private static void process(EventTopicSubscriber topicAnnotation, Object obj, Method method, boolean add) {
        String topic = topicAnnotation.topic();
        if (topic == null) {
            throw new IllegalArgumentException("Topic cannot be null for EventTopicSubscriber annotation");
        }
        Class<? extends EventService> eventServiceClass = topicAnnotation.autoCreateEventServiceClass();
        String eventServiceName = topicAnnotation.eventServiceName();
        EventService eventService = AnnotationProcessor.getEventServiceFromAnnotation(eventServiceName, eventServiceClass);
        int priority = topicAnnotation.priority();
        if (add) {
            ProxyTopicSubscriber subscriber = new ProxyTopicSubscriber(obj, method, topicAnnotation.referenceStrength(), priority, eventService, topic, false);
            eventService.subscribeStrongly(topic, (org.bushe.swing.event.EventTopicSubscriber)subscriber);
        } else {
            eventService.unsubscribe(topic, obj);
        }
    }

    private static void process(EventSubscriber annotation, Object obj, Method method, boolean add) {
        Class<?> eventClass = annotation.eventClass();
        if (eventClass == null) {
            throw new IllegalArgumentException("Event class cannot be null for EventSubscriber annotation");
        }
        if (UseTheClassOfTheAnnotatedMethodsParameter.class.equals((Object)eventClass)) {
            Class<?>[] params = method.getParameterTypes();
            if (params.length < 1) {
                throw new RuntimeException("Expected annotated method to have one parameter.");
            }
            eventClass = params[0];
        }
        Class<? extends EventService> eventServiceClass = annotation.autoCreateEventServiceClass();
        String eventServiceName = annotation.eventServiceName();
        EventService eventService = AnnotationProcessor.getEventServiceFromAnnotation(eventServiceName, eventServiceClass);
        if (add) {
            int priority = annotation.priority();
            BaseProxySubscriber subscriber = new BaseProxySubscriber(obj, method, annotation.referenceStrength(), priority, eventService, eventClass, false);
            if (annotation.exact()) {
                eventService.subscribeExactlyStrongly(eventClass, subscriber);
            } else {
                eventService.subscribeStrongly(eventClass, subscriber);
            }
        } else if (annotation.exact()) {
            eventService.unsubscribeExactly(eventClass, obj);
        } else {
            eventService.unsubscribe(eventClass, obj);
        }
    }

    private static void process(final RuntimeTopicEventSubscriber annotation, final Object subscriber, final Method method, boolean add) {
        EventTopicSubscriber eventTopicSubscriber = new EventTopicSubscriber(){

            @Override
            public Class<? extends EventService> autoCreateEventServiceClass() {
                return annotation.autoCreateEventServiceClass();
            }

            @Override
            public String eventServiceName() {
                return annotation.eventServiceName();
            }

            @Override
            public ReferenceStrength referenceStrength() {
                return annotation.referenceStrength();
            }

            @Override
            public int priority() {
                return annotation.priority();
            }

            @Override
            public String topic() {
                return AnnotationProcessor.getTopic(annotation.methodName(), subscriber, method);
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return annotation.annotationType();
            }
        };
        AnnotationProcessor.process(eventTopicSubscriber, subscriber, method, add);
    }

    private static void process(final RuntimeTopicPatternEventSubscriber annotation, final Object subscriber, final Method method, boolean add) {
        EventTopicPatternSubscriber eventTopicPatternSubscriber = new EventTopicPatternSubscriber(){

            @Override
            public Class<? extends EventService> autoCreateEventServiceClass() {
                return annotation.autoCreateEventServiceClass();
            }

            @Override
            public String eventServiceName() {
                return annotation.eventServiceName();
            }

            @Override
            public ReferenceStrength referenceStrength() {
                return annotation.referenceStrength();
            }

            @Override
            public int priority() {
                return annotation.priority();
            }

            @Override
            public boolean exact() {
                return annotation.exact();
            }

            @Override
            public String topicPattern() {
                return AnnotationProcessor.getTopic(annotation.methodName(), subscriber, method);
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return annotation.annotationType();
            }
        };
        AnnotationProcessor.process(eventTopicPatternSubscriber, subscriber, method, add);
    }

    private static void process(VetoTopicPatternSubscriber topicPatternAnnotation, Object obj, Method method, boolean add) {
        String topicPattern = topicPatternAnnotation.topicPattern();
        if (topicPattern == null) {
            throw new IllegalArgumentException("Topic pattern cannot be null for VetoTopicPatternSubscriber annotation");
        }
        Class<? extends EventService> eventServiceClass = topicPatternAnnotation.autoCreateEventServiceClass();
        String eventServiceName = topicPatternAnnotation.eventServiceName();
        EventService eventService = AnnotationProcessor.getEventServiceFromAnnotation(eventServiceName, eventServiceClass);
        int priority = topicPatternAnnotation.priority();
        Pattern pattern = Pattern.compile(topicPattern);
        ProxyTopicPatternSubscriber subscriber = new ProxyTopicPatternSubscriber(obj, method, topicPatternAnnotation.referenceStrength(), priority, eventService, topicPattern, pattern, true);
        if (add) {
            eventService.subscribeVetoListenerStrongly(pattern, (VetoTopicEventListener)subscriber);
        } else {
            eventService.unsubscribeVeto(pattern, obj);
        }
    }

    private static void process(VetoTopicSubscriber topicAnnotation, Object obj, Method method, boolean add) {
        String topic = topicAnnotation.topic();
        if (topic == null) {
            throw new IllegalArgumentException("Topic cannot be null for VetoTopicSubscriber annotation");
        }
        Class<? extends EventService> eventServiceClass = topicAnnotation.autoCreateEventServiceClass();
        String eventServiceName = topicAnnotation.eventServiceName();
        EventService eventService = AnnotationProcessor.getEventServiceFromAnnotation(eventServiceName, eventServiceClass);
        int priority = topicAnnotation.priority();
        ProxyTopicSubscriber subscriber = new ProxyTopicSubscriber(obj, method, topicAnnotation.referenceStrength(), priority, eventService, topic, true);
        if (add) {
            eventService.subscribeVetoListenerStrongly(topic, (VetoTopicEventListener)subscriber);
        } else {
            eventService.unsubscribeVeto(topic, obj);
        }
    }

    private static void process(VetoSubscriber annotation, Object obj, Method method, boolean add) {
        Class<?> eventClass = annotation.eventClass();
        if (eventClass == null) {
            throw new IllegalArgumentException("Event class cannot be null for VetoSubscriber annotation");
        }
        if (UseTheClassOfTheAnnotatedMethodsParameter.class.equals((Object)eventClass)) {
            Class<?>[] params = method.getParameterTypes();
            if (params.length < 1) {
                throw new RuntimeException("Expected annotated method to have one parameter.");
            }
            eventClass = params[0];
        }
        Class<? extends EventService> eventServiceClass = annotation.autoCreateEventServiceClass();
        String eventServiceName = annotation.eventServiceName();
        EventService eventService = AnnotationProcessor.getEventServiceFromAnnotation(eventServiceName, eventServiceClass);
        int priority = annotation.priority();
        BaseProxySubscriber subscriber = new BaseProxySubscriber(obj, method, annotation.referenceStrength(), priority, eventService, eventClass, true);
        if (add) {
            if (annotation.exact()) {
                eventService.subscribeVetoListenerExactlyStrongly(eventClass, subscriber);
            } else {
                eventService.subscribeVetoListenerStrongly(eventClass, subscriber);
            }
        } else if (annotation.exact()) {
            eventService.unsubscribeVetoExactly(eventClass, obj);
        } else {
            eventService.unsubscribeVeto(eventClass, obj);
        }
    }

    private static void process(final VetoRuntimeTopicSubscriber annotation, final Object subscriber, final Method method, boolean add) {
        VetoTopicSubscriber eventTopicSubscriber = new VetoTopicSubscriber(){

            @Override
            public Class<? extends EventService> autoCreateEventServiceClass() {
                return annotation.autoCreateEventServiceClass();
            }

            @Override
            public String eventServiceName() {
                return annotation.eventServiceName();
            }

            @Override
            public ReferenceStrength referenceStrength() {
                return annotation.referenceStrength();
            }

            @Override
            public int priority() {
                return annotation.priority();
            }

            @Override
            public String topic() {
                return AnnotationProcessor.getTopic(annotation.methodName(), subscriber, method);
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return annotation.annotationType();
            }
        };
        AnnotationProcessor.process(eventTopicSubscriber, subscriber, method, add);
    }

    private static void process(final VetoRuntimeTopicPatternSubscriber annotation, final Object subscriber, final Method method, boolean add) {
        VetoTopicPatternSubscriber eventTopicPatternSubscriber = new VetoTopicPatternSubscriber(){

            @Override
            public Class<? extends EventService> autoCreateEventServiceClass() {
                return annotation.autoCreateEventServiceClass();
            }

            @Override
            public String eventServiceName() {
                return annotation.eventServiceName();
            }

            @Override
            public ReferenceStrength referenceStrength() {
                return annotation.referenceStrength();
            }

            @Override
            public int priority() {
                return annotation.priority();
            }

            public boolean exact() {
                return annotation.exact();
            }

            @Override
            public String topicPattern() {
                return AnnotationProcessor.getTopic(annotation.methodName(), subscriber, method);
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return annotation.annotationType();
            }
        };
        AnnotationProcessor.process(eventTopicPatternSubscriber, subscriber, method, add);
    }

    private static String getTopic(String methodName, Object subscriber, Method method) {
        try {
            Method runtimeEvalMethod = subscriber.getClass().getMethod(methodName, new Class[0]);
            runtimeEvalMethod.setAccessible(true);
            return runtimeEvalMethod.invoke(subscriber, new Object[0]).toString();
        }
        catch (SecurityException e) {
            throw new RuntimeException("Could not retrieve method for subscription. Method: " + methodName, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not retrieve method for subscription. Method: " + methodName, e);
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
            throw new RuntimeException("Could not invoke method for subscription. Method: " + methodName, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not invoke method for subscription. Method: " + methodName, e);
        }
    }

    private static EventService getEventServiceFromAnnotation(String eventServiceName, Class<? extends EventService> eventServiceClass) {
        EventService eventService = EventServiceLocator.getEventService(eventServiceName);
        if (eventService == null) {
            if ("EventBus".equals(eventServiceName)) {
                eventService = EventServiceLocator.getSwingEventService();
            } else {
                try {
                    eventService = eventServiceClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Could not instance of create EventService class " + eventServiceClass, e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Could not instance of create EventService class " + eventServiceClass, e);
                }
                try {
                    EventServiceLocator.setEventService(eventServiceName, eventService);
                }
                catch (EventServiceExistsException e) {
                    eventService = EventServiceLocator.getEventService(eventServiceName);
                }
            }
        }
        return eventService;
    }
}

