/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.xpp3;

import de.lessvoid.xml.xpp3.Attributes;
import de.lessvoid.xml.xpp3.SubstitutionGroup;
import de.lessvoid.xml.xpp3.XmlProcessor;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlParser {
    @Nonnull
    private static final Logger log = Logger.getLogger(XmlParser.class.getName());
    @Nonnull
    private final XmlPullParser xpp;

    public XmlParser(@Nonnull XmlPullParser xppParam) {
        this.xpp = xppParam;
    }

    public void read(@Nonnull @WillNotClose InputStream inputStream) throws Exception {
        this.xpp.setInput(inputStream, null);
    }

    public void required(@Nonnull String tag, @Nonnull XmlProcessor xmlElement) throws Exception {
        if (this.isEndTag()) {
            throw new Exception("found end tag but required tag [" + tag + "]");
        }
        if (!this.matchesTag(tag)) {
            throw new Exception("Expected tag [" + tag + "] but was [" + this.xpp.getName() + "]");
        }
        this.processElement(xmlElement);
        this.nextTag();
    }

    public void optional(@Nonnull String tag, @Nonnull XmlProcessor xmlElement) throws Exception {
        if (this.isEndTag()) {
            return;
        }
        if (!this.matchesTag(tag)) {
            return;
        }
        this.processElement(xmlElement);
        this.nextTag();
    }

    public void zeroOrMore(@Nonnull String tag, @Nonnull XmlProcessor xmlElement) throws Exception {
        if (this.isEndTag()) {
            return;
        }
        if (!this.matchesTag(tag)) {
            return;
        }
        this.processElement(xmlElement);
        this.nextTag();
        this.zeroOrMore(tag, xmlElement);
    }

    private boolean isEndTag() throws Exception {
        return 3 == this.xpp.getEventType();
    }

    public void zeroOrMore(@Nonnull SubstitutionGroup substGroup) throws Exception {
        if (this.isEndTag()) {
            return;
        }
        XmlProcessor element = substGroup.matches(this.xpp.getName());
        if (element == null) {
            return;
        }
        this.processElement(element);
        this.nextTag();
        this.zeroOrMore(substGroup);
    }

    public void oneOrMore(@Nonnull String tag, @Nonnull XmlProcessor xmlElement) throws Exception {
        if (this.isEndTag()) {
            throw new Exception("End tag reached but was expecting [" + tag + "]");
        }
        if (!this.matchesTag(tag)) {
            throw new Exception("Expected tag [" + tag + "] but was [" + this.xpp.getName() + "]");
        }
        this.processElement(xmlElement);
        this.nextTag();
        this.zeroOrMore(tag, xmlElement);
    }

    private void processElement(@Nonnull XmlProcessor xmlElement) throws Exception {
        log.fine("process element: " + xmlElement.getClass().getName());
        try {
            xmlElement.process(this, new Attributes(this.xpp));
        }
        catch (Exception ex) {
            if (!(ex instanceof XmlPullParserException)) {
                throw new XmlPullParserException("Error parsing document.", this.xpp, (Throwable)ex);
            }
            throw ex;
        }
    }

    private boolean matchesTag(@Nonnull String tag) {
        return tag.equals(this.xpp.getName());
    }

    public void nextTag() throws Exception {
        if (this.xpp.getEventType() == 1) {
            return;
        }
        int eventType = this.xpp.next();
        while (eventType != 1) {
            if (eventType == 3) {
                if (log.isLoggable(Level.FINE)) {
                    this.indent();
                    log.fine(this.indent() + "END <" + this.xpp.getName() + ">");
                }
                return;
            }
            if (eventType == 2) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.indent() + "START <" + this.xpp.getName() + ">");
                }
                return;
            }
            eventType = this.xpp.next();
        }
    }

    @Nonnull
    private String indent() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.xpp.getDepth(); ++i) {
            b.append(' ');
        }
        return b.toString();
    }
}

