/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.tools;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MethodResolver {
    private static final Logger log = Logger.getLogger(MethodResolver.class.getName());

    private MethodResolver() {
    }

    @Nullable
    public static Method findMethod(@Nullable Class<?> c, @Nonnull String methodName) {
        Method[] ms;
        if (c == null) {
            return null;
        }
        String methodNameOnly = MethodResolver.extractMethodName(methodName);
        if (methodNameOnly == null) {
            log.warning("Could not extract method from [" + methodName + "]");
            return null;
        }
        for (Method m : ms = c.getMethods()) {
            if (!methodNameOnly.equalsIgnoreCase(m.getName())) continue;
            return m;
        }
        return MethodResolver.findMethod(c.getSuperclass(), methodName);
    }

    @Nullable
    public static Method findMethodWithArgs(@Nullable Class<?> c, @Nonnull String methodName, Class<?> ... parameters) {
        Method[] ms;
        if (c == null) {
            return null;
        }
        String methodNameOnly = MethodResolver.extractMethodName(methodName);
        if (methodNameOnly == null) {
            log.warning("Could not extract method from [" + methodName + "]");
            return null;
        }
        for (Method m : ms = c.getMethods()) {
            if (!methodNameOnly.equalsIgnoreCase(m.getName()) || !Arrays.equals(m.getParameterTypes(), parameters)) continue;
            return m;
        }
        return null;
    }

    @Nonnull
    public static String[] extractParameters(@Nonnull String methodName) {
        String parameterString = MethodResolver.extractArgs(methodName);
        if (parameterString.length() == 0) {
            return new String[0];
        }
        String[] result = parameterString.split(",");
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    @Nonnull
    public static String extractArgs(@Nonnull String methodName) {
        int startIdx = methodName.indexOf("(");
        int endIdx = methodName.lastIndexOf(")");
        if (startIdx == -1 || endIdx == -1) {
            return "";
        }
        return methodName.substring(startIdx + 1, endIdx);
    }

    @Nullable
    private static String extractMethodName(@Nonnull String methodName) {
        if (!methodName.contains("(")) {
            return null;
        }
        return methodName.substring(0, methodName.indexOf(40));
    }
}

