/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools;

import de.lessvoid.nifty.tools.SizeValueType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SizeValue {
    public static final float MAX_PERCENT = 100.0f;
    @Nonnull
    private static final SizeValue DEF = new SizeValue(SizeValueType.Default);
    @Nonnull
    private static final SizeValue MAX = new SizeValue(SizeValueType.Maximum);
    @Nonnull
    private static final SizeValue NULL_PX = new SizeValue(0, SizeValueType.Pixel);
    @Nonnull
    private static final SizeValue SUM = new SizeValue(SizeValueType.Sum);
    @Nonnull
    private static final SizeValue WILDCARD = new SizeValue(SizeValueType.Wildcard);
    @Nonnull
    private final SizeValueType type;
    private final float value;
    private final boolean hasCalculatedValue;
    private final boolean hasValue;

    public SizeValue(@Nonnull SizeValueType type) {
        if (type.getValueRequirement() == SizeValueType.ValueRequirement.Required) {
            throw new IllegalArgumentException("Size value type " + type.name() + " requires a value!");
        }
        this.type = type;
        this.value = 0.0f;
        this.hasValue = false;
        this.hasCalculatedValue = false;
    }

    public SizeValue(int value, @Nonnull SizeValueType type) {
        switch (type.getValueRequirement()) {
            case Forbidden: {
                throw new IllegalArgumentException("Size value type " + type.name() + " does not allow a value.");
            }
            case CalculatedOnly: {
                throw new IllegalArgumentException("Size value type " + type.name() + " does only allow calculated values");
            }
        }
        this.type = type;
        this.value = value;
        this.hasValue = true;
        this.hasCalculatedValue = false;
    }

    public SizeValue(@Nonnull SizeValueType type, int calculatedValue) {
        switch (type.getValueRequirement()) {
            case Forbidden: {
                throw new IllegalArgumentException("Size value type " + type.name() + " does not allow a value.");
            }
            case Required: {
                throw new IllegalArgumentException("Size value type " + type.name() + " requires a value!");
            }
        }
        this.type = type;
        this.value = calculatedValue;
        this.hasValue = false;
        this.hasCalculatedValue = true;
    }

    public SizeValue(@Nullable String valueParam) {
        this.hasCalculatedValue = false;
        if (valueParam == null || valueParam.isEmpty() || valueParam.equals("default")) {
            this.type = SizeValueType.Default;
            this.value = 0.0f;
            this.hasValue = false;
            return;
        }
        if (valueParam.equals("sum")) {
            this.type = SizeValueType.Sum;
            this.value = 0.0f;
            this.hasValue = false;
            return;
        }
        if (valueParam.equals("max")) {
            this.type = SizeValueType.Maximum;
            this.value = 0.0f;
            this.hasValue = false;
            return;
        }
        SizeValueType selectedType = null;
        for (SizeValueType currentType : SizeValueType.values()) {
            if (!valueParam.endsWith(currentType.getExtension())) continue;
            selectedType = currentType;
            break;
        }
        if (selectedType == null) {
            this.type = SizeValueType.Pixel;
            try {
                this.value = Float.valueOf(valueParam).floatValue();
                this.hasValue = true;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("String value [" + valueParam + "] does not fit the required format.", e);
            }
        } else {
            int extensionLength;
            this.type = selectedType;
            int paramLength = valueParam.length();
            if (paramLength > (extensionLength = this.type.getExtension().length())) {
                switch (this.type.getValueRequirement()) {
                    case CalculatedOnly: {
                        throw new IllegalArgumentException("Setting the value by string is not allowed for types that only allow a calculated value.");
                    }
                    case Forbidden: {
                        throw new IllegalArgumentException("The size type " + this.type.name() + " does not allow any values.");
                    }
                }
                try {
                    this.value = Float.valueOf(valueParam.substring(0, paramLength - extensionLength)).floatValue();
                    this.hasValue = true;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("String value [" + valueParam + "] does not fit the required format.", e);
                }
            } else {
                if (this.type.getValueRequirement() == SizeValueType.ValueRequirement.Required) {
                    throw new IllegalArgumentException("Size value type " + this.type.name() + " requires a value!");
                }
                this.value = 0.0f;
                this.hasValue = false;
            }
        }
    }

    @Nonnull
    public static SizeValue def() {
        return DEF;
    }

    @Nonnull
    public static SizeValue def(int pixelValue) {
        return new SizeValue(SizeValueType.Default, pixelValue);
    }

    @Nonnull
    public static SizeValue px(int pixelValue) {
        if (pixelValue == 0) {
            return NULL_PX;
        }
        return new SizeValue(pixelValue, SizeValueType.Pixel);
    }

    @Nonnull
    public static SizeValue percent(int percentage) {
        return new SizeValue(percentage, SizeValueType.Percent);
    }

    @Nonnull
    public static SizeValue percentHeight(int percentage) {
        return new SizeValue(percentage, SizeValueType.PercentHeight);
    }

    @Nonnull
    public static SizeValue percentWidth(int percentage) {
        return new SizeValue(percentage, SizeValueType.PercentWidth);
    }

    @Nonnull
    public static SizeValue wildcard() {
        return WILDCARD;
    }

    @Nonnull
    public static SizeValue wildcard(int computedValue) {
        return new SizeValue(SizeValueType.Wildcard, computedValue);
    }

    @Nonnull
    public static SizeValue sum() {
        return SUM;
    }

    @Nonnull
    public static SizeValue sum(int computedValue) {
        return new SizeValue(SizeValueType.Sum, computedValue);
    }

    @Nonnull
    public static SizeValue max() {
        return MAX;
    }

    @Nonnull
    public static SizeValue max(int computedValue) {
        return new SizeValue(SizeValueType.Maximum, computedValue);
    }

    public boolean isIndependentFromParent() {
        return this.type.isIndependent();
    }

    @Deprecated
    public boolean isPercentOrPixel() {
        return this.hasValue();
    }

    public boolean hasValue() {
        return this.hasValue || this.hasCalculatedValue;
    }

    public float getValue(float range) {
        if (this.isPercent()) {
            return range / 100.0f * this.value;
        }
        if (this.isPixel()) {
            return this.value;
        }
        return -1.0f;
    }

    public int getValueAsInt(float range) {
        if (this.isPercent()) {
            return Math.round(range / 100.0f * this.value);
        }
        if (this.isPixel()) {
            return Math.round(this.value);
        }
        return -1;
    }

    public String getValueAsString() {
        StringBuilder builder = new StringBuilder();
        if (this.hasValue) {
            builder.append(this.value);
        }
        builder.append(this.type.getExtension());
        return builder.toString();
    }

    public boolean isPixel() {
        return this.hasValue() && !this.isPercent();
    }

    public boolean isPercent() {
        if (!this.hasValue()) {
            return false;
        }
        switch (this.type) {
            case Percent: 
            case PercentWidth: 
            case PercentHeight: {
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.hasValue) {
            builder.append(this.value);
        }
        builder.append(this.type.getExtension());
        if (this.hasCalculatedValue) {
            builder.append('[').append(this.value).append("px]");
        }
        return builder.toString();
    }

    public boolean hasDefault() {
        return this.type == SizeValueType.Default;
    }

    public boolean hasWidthSuffix() {
        return this.type == SizeValueType.PercentWidth;
    }

    public boolean hasHeightSuffix() {
        return this.type == SizeValueType.PercentHeight;
    }

    public boolean hasWildcard() {
        return this.type == SizeValueType.Wildcard;
    }

    public boolean hasSum() {
        return this.type == SizeValueType.Sum;
    }

    public boolean hasMax() {
        return this.type == SizeValueType.Maximum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SizeValue sizeValue = (SizeValue)o;
        if (this.hasCalculatedValue != sizeValue.hasCalculatedValue) {
            return false;
        }
        if (this.hasValue != sizeValue.hasValue) {
            return false;
        }
        if (Float.compare(sizeValue.value, this.value) != 0) {
            return false;
        }
        return this.type == sizeValue.type;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.value != 0.0f ? Float.floatToIntBits(this.value) : 0);
        result = 31 * result + (this.hasCalculatedValue ? 1 : 0);
        result = 31 * result + (this.hasValue ? 1 : 0);
        return result;
    }
}

