/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools;

import de.lessvoid.nifty.tools.Factory;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class EnumStorage<K extends Enum<K>, V> {
    @Nonnull
    private final Map<K, V> storage;
    @Nonnull
    private final Factory<V> valueFactory;

    public EnumStorage(@Nonnull Class<K> enumClass, @Nonnull Factory<V> factory) {
        this.storage = new EnumMap(enumClass);
        this.valueFactory = factory;
    }

    public boolean isSet(@Nonnull K key) {
        return this.storage.containsKey(key);
    }

    @Nonnull
    public V get(@Nonnull K key) {
        V value = this.storage.get(key);
        if (value == null) {
            value = this.valueFactory.createNew();
            this.storage.put(key, value);
        }
        return value;
    }
}

