/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools;

import de.lessvoid.nifty.tools.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ColorValueParser {
    private boolean isColor;
    private int nextIndex;
    @Nullable
    private Color color;

    public ColorValueParser() {
        this.setNoResult();
    }

    public boolean isColor() {
        return this.isColor;
    }

    public int getNextIndex() {
        return this.nextIndex;
    }

    @Nullable
    public Color getColor() {
        return this.color;
    }

    public boolean isColor(@Nonnull String text, int startIdx) {
        int endIdx;
        if (text.startsWith("\\#", startIdx) && (endIdx = text.indexOf(35, startIdx + 2)) != -1) {
            this.setResult(text.substring(startIdx + 1, endIdx), endIdx + 1);
            return this.isColor;
        }
        this.setNoResult();
        return false;
    }

    private void setNoResult() {
        this.nextIndex = -1;
        this.color = null;
        this.isColor = false;
    }

    private void setResult(@Nonnull String value, int endIdx) {
        this.nextIndex = -1;
        this.color = null;
        this.isColor = Color.check(value);
        if (this.isColor) {
            this.color = new Color(value);
            this.nextIndex = endIdx;
        }
    }
}

