/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ColorValidator {
    @Nonnull
    private static final Pattern colorPattern = Pattern.compile("#\\p{XDigit}{3,8}");

    public static boolean isValid(@Nullable String toCheck) {
        if (toCheck == null) {
            return false;
        }
        if (!toCheck.startsWith("#")) {
            return false;
        }
        int digits = toCheck.length() - 1;
        if (digits == 3 || digits == 4 || digits == 6 || digits == 8) {
            return ColorValidator.checkSyntax(toCheck);
        }
        return false;
    }

    public static boolean isShortMode(@Nullable String toCheck) {
        return ColorValidator.isColor(toCheck, 4);
    }

    public static boolean isShortModeWithoutAlpha(@Nullable String toCheck) {
        return ColorValidator.isColor(toCheck, 3);
    }

    public static boolean isLongMode(@Nullable String toCheck) {
        return ColorValidator.isColor(toCheck, 8);
    }

    public static boolean isLongModeWithoutAlpha(@Nullable String toCheck) {
        return ColorValidator.isColor(toCheck, 6);
    }

    private static boolean isColor(@Nullable String toCheck, int components) {
        return toCheck != null && toCheck.length() == components + 1 && ColorValidator.checkSyntax(toCheck);
    }

    private static boolean checkSyntax(@Nonnull String toCheck) {
        return colorPattern.matcher(toCheck).matches();
    }

    private ColorValidator() {
    }
}

