/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.screen;

import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class MouseOverHandler {
    @Nonnull
    private final ArrayList<Element> mouseOverElements = new ArrayList();
    @Nonnull
    private final ArrayList<Element> mouseElements = new ArrayList();
    private boolean interactElementInTransitAvailable = false;

    public void reset() {
        this.mouseOverElements.clear();
        this.mouseElements.clear();
        this.interactElementInTransitAvailable = false;
    }

    public void addMouseOverElement(Element element) {
        this.mouseOverElements.add(element);
    }

    public void addMouseElement(Element element) {
        this.mouseElements.add(element);
    }

    @Nonnull
    public String getInfoString() {
        StringBuffer result = new StringBuffer();
        result.append("mouse over elements: ");
        this.outputElements(result, this.mouseOverElements);
        result.append(" mouse elements: ");
        this.outputElements(result, this.mouseElements);
        return result.toString();
    }

    private void outputElements(@Nonnull StringBuffer result, @Nonnull ArrayList<Element> elements) {
        if (elements.isEmpty()) {
            result.append("---");
        } else {
            for (int i = elements.size() - 1; i >= 0; --i) {
                Element element = elements.get(i);
                result.append("[").append(element.getId()).append("]");
            }
        }
    }

    public void processMouseOverEvent(Element rootElement, @Nonnull NiftyMouseInputEvent mouseEvent, long eventTime) {
        for (int i = this.mouseOverElements.size() - 1; i >= 0; --i) {
            Element element = this.mouseOverElements.get(i);
            if (!element.mouseOverEvent(mouseEvent, eventTime)) continue;
            return;
        }
    }

    public void processMouseEvent(@Nonnull NiftyMouseInputEvent mouseEvent, long eventTime) {
        Element element;
        int i;
        for (i = this.mouseElements.size() - 1; i >= 0; --i) {
            element = this.mouseElements.get(i);
            element.mouseEventHoverPreprocess(mouseEvent, eventTime);
        }
        for (i = this.mouseElements.size() - 1; i >= 0 && !(element = this.mouseElements.get(i)).mouseEvent(mouseEvent, eventTime); --i) {
        }
        for (i = this.mouseOverElements.size() - 1; i >= 0 && !(element = this.mouseOverElements.get(i)).mouseEvent(mouseEvent, eventTime); --i) {
        }
    }

    public boolean hitsElement() {
        return this.hasMouseOverElements() || this.interactElementInTransitAvailable;
    }

    private boolean hasMouseOverElements() {
        return !this.mouseOverElements.isEmpty();
    }

    public void canTheoreticallyHandleMouse(Element element) {
        this.interactElementInTransitAvailable = true;
    }
}

