/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch.spi.core;

import de.lessvoid.nifty.render.batch.spi.core.CoreMatrix4f;
import javax.annotation.Nonnull;

public class CoreMatrixFactory {
    @Nonnull
    public static CoreMatrix4f createOrthoMatrix(float left, float right, float bottom, float top) {
        float zNear = -9999.0f;
        float zFar = 9999.0f;
        CoreMatrix4f projection = new CoreMatrix4f();
        projection.m00 = 2.0f / (right - left);
        projection.m11 = 2.0f / (top - bottom);
        projection.m22 = -2.0f / (zFar - zNear);
        projection.m30 = -(right + left) / (right - left);
        projection.m31 = -(top + bottom) / (top - bottom);
        projection.m32 = -(zFar + zNear) / (zFar - zNear);
        projection.m33 = 1.0f;
        return projection;
    }

    public static CoreMatrix4f createPerspectiveMatrix(float left, float right, float top, float bottom, float zNear, float zFar) {
        CoreMatrix4f projection = new CoreMatrix4f();
        projection.m00 = 2.0f * zNear / (right - left);
        projection.m11 = 2.0f * zNear / (top - bottom);
        projection.m20 = (right + left) / (right - left);
        projection.m21 = (top + bottom) / (top - bottom);
        projection.m22 = -(zFar + zNear) / (zFar - zNear);
        projection.m23 = -1.0f;
        projection.m32 = -2.0f * zFar * zNear / (zFar - zNear);
        projection.m33 = 0.0f;
        return projection;
    }

    @Nonnull
    public static CoreMatrix4f createPerspectiveMatrix(float fov, float aspectRatio, float zNear, float zFar) {
        float e;
        CoreMatrix4f projection = new CoreMatrix4f();
        projection.m00 = e = 1.0f / (float)Math.tan(fov / 2.0f);
        projection.m11 = e / aspectRatio;
        projection.m22 = -(zFar + zNear) / (zFar - zNear);
        projection.m23 = -1.0f;
        projection.m32 = -2.0f * zFar * zNear / (zFar - zNear);
        projection.m33 = 0.0f;
        return projection;
    }
}

