/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch.core;

import de.lessvoid.nifty.render.batch.CheckGL;
import de.lessvoid.nifty.render.batch.spi.BufferFactory;
import de.lessvoid.nifty.render.batch.spi.core.CoreGL;
import java.nio.IntBuffer;
import javax.annotation.Nonnull;

public class CoreVAO {
    @Nonnull
    private final CoreGL gl;
    @Nonnull
    private final IntBuffer vertexArrayBuffer;
    private int vao;

    public CoreVAO(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory) {
        this.gl = gl;
        this.vertexArrayBuffer = bufferFactory.createNativeOrderedIntBuffer(1);
        this.init();
    }

    public void bind() {
        this.gl.glBindVertexArray(this.vao);
        CheckGL.checkGLError(this.gl, "glBindVertexArray");
    }

    public void unbind() {
        this.gl.glBindVertexArray(0);
        CheckGL.checkGLError(this.gl, "glBindVertexArray(0)");
    }

    public void delete() {
        this.vertexArrayBuffer.clear();
        this.vertexArrayBuffer.put(0, this.vao);
        this.gl.glDeleteVertexArrays(1, this.vertexArrayBuffer);
    }

    public void enableVertexAttributef(int index, int size, int stride, int offset) {
        this.gl.glVertexAttribPointer(index, size, this.gl.GL_FLOAT(), false, stride * 4, offset * 4);
        this.gl.glEnableVertexAttribArray(index);
        CheckGL.checkGLError(this.gl, "glVertexAttribPointer (" + index + ")");
    }

    private void init() {
        this.vertexArrayBuffer.clear();
        this.gl.glGenVertexArrays(1, this.vertexArrayBuffer);
        this.vao = this.vertexArrayBuffer.get(0);
        CheckGL.checkGLError(this.gl, "glGenVertexArrays");
    }
}

