/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch.core;

import de.lessvoid.nifty.render.batch.CheckGL;
import de.lessvoid.nifty.render.batch.spi.BufferFactory;
import de.lessvoid.nifty.render.batch.spi.core.CoreGL;
import de.lessvoid.nifty.render.batch.spi.core.CoreMatrix4f;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CoreShader {
    @Nonnull
    private static final Logger log = Logger.getLogger(CoreShader.class.getName());
    @Nonnull
    private final CoreGL gl;
    @Nonnull
    private final BufferFactory bufferFactory;
    @Nonnull
    private final HashMap<String, Integer> parameter = new HashMap();
    @Nonnull
    private final FloatBuffer matrixBuffer;
    private final String[] attributes;
    private final int program;
    private IntBuffer params;

    @Nonnull
    public static CoreShader createShader(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory) {
        return new CoreShader(gl, bufferFactory, new String[0]);
    }

    @Nonnull
    public static CoreShader createShaderWithVertexAttributes(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, String ... vertexAttributes) {
        return new CoreShader(gl, bufferFactory, vertexAttributes);
    }

    public int vertexShader(@Nonnull String filename) {
        return this.vertexShader(this.getStream(filename));
    }

    public int fragmentShader(@Nonnull String filename) {
        return this.fragmentShader(this.getStream(filename));
    }

    public int geometryShader(@Nonnull String filename) {
        return this.geometryShader(this.getStream(filename));
    }

    public int vertexShader(@Nonnull File file) throws FileNotFoundException {
        return this.vertexShader(this.getStream(file));
    }

    public int fragmentShader(@Nonnull File file) throws FileNotFoundException {
        return this.fragmentShader(this.getStream(file));
    }

    public int geometryShader(@Nonnull File file) throws FileNotFoundException {
        return this.geometryShader(this.getStream(file));
    }

    public int vertexShader(@Nonnull InputStream source) {
        int shaderId = this.gl.glCreateShader(this.gl.GL_VERTEX_SHADER());
        this.checkGLError("glCreateShader(GL_VERTEX_SHADER)");
        this.prepareShader(source, shaderId);
        this.gl.glAttachShader(this.program, shaderId);
        this.checkGLError("glAttachShader");
        return shaderId;
    }

    public int fragmentShader(@Nonnull InputStream source) {
        int shaderId = this.gl.glCreateShader(this.gl.GL_FRAGMENT_SHADER());
        this.checkGLError("glCreateShader(GL_FRAGMENT_SHADER)");
        this.prepareShader(source, shaderId);
        this.gl.glAttachShader(this.program, shaderId);
        this.checkGLError("glAttachShader");
        return shaderId;
    }

    public int geometryShader(@Nonnull InputStream source) {
        int shaderId = this.gl.glCreateShader(this.gl.GL_GEOMETRY_SHADER());
        this.checkGLError("glCreateShader(GL_GEOMETRY_SHADER)");
        this.prepareShader(source, shaderId);
        this.gl.glAttachShader(this.program, shaderId);
        this.checkGLError("glAttachShader");
        return shaderId;
    }

    public void vertexShader(int shaderId, @Nonnull String filename) {
        this.vertexShader(shaderId, this.getStream(filename));
    }

    public void fragmentShader(int shaderId, @Nonnull String filename) {
        this.fragmentShader(shaderId, this.getStream(filename));
    }

    public void geometryShader(int shaderId, @Nonnull String filename) {
        this.geometryShader(shaderId, this.getStream(filename));
    }

    public void vertexShader(int shaderId, @Nonnull File file) throws FileNotFoundException {
        this.vertexShader(shaderId, this.getStream(file));
    }

    public void fragmentShader(int shaderId, @Nonnull File file) throws FileNotFoundException {
        this.fragmentShader(shaderId, this.getStream(file));
    }

    public void geometryShader(int shaderId, @Nonnull File file) throws FileNotFoundException {
        this.geometryShader(shaderId, this.getStream(file));
    }

    public void vertexShader(int shaderId, @Nonnull InputStream source) {
        this.prepareShader(source, shaderId);
    }

    public void fragmentShader(int shaderId, @Nonnull InputStream source) {
        this.prepareShader(source, shaderId);
    }

    public void geometryShader(int shaderId, @Nonnull InputStream source) {
        this.prepareShader(source, shaderId);
    }

    public void link() {
        for (int i = 0; i < this.attributes.length; ++i) {
            this.gl.glBindAttribLocation(this.program, i, this.attributes[i]);
            this.checkGLError("glBindAttribLocation (" + this.attributes[i] + ")");
        }
        this.gl.glLinkProgram(this.program);
        this.checkGLError("glLinkProgram");
        this.params.clear();
        this.gl.glGetProgramiv(this.program, this.gl.GL_LINK_STATUS(), this.params);
        if (this.params.get(0) != this.gl.GL_TRUE()) {
            log.warning("link error: " + this.gl.glGetProgramInfoLog(this.program));
            this.checkGLError("glGetProgramInfoLog");
        }
        this.checkGLError("glGetProgram");
    }

    public void setUniformf(@Nonnull String name, float value) {
        this.gl.glUniform1f(this.getLocation(name), value);
        this.checkGLError("glUniform1f");
    }

    public void setUniformf(@Nonnull String name, float v1, float v2) {
        this.gl.glUniform2f(this.getLocation(name), v1, v2);
        this.checkGLError("glUniform2f");
    }

    public void setUniformf(@Nonnull String name, float v1, float v2, float v3) {
        this.gl.glUniform3f(this.getLocation(name), v1, v2, v3);
        this.checkGLError("glUniform3f");
    }

    public void setUniformf(@Nonnull String name, float x, float y, float z, float w) {
        this.gl.glUniform4f(this.getLocation(name), x, y, z, w);
        this.checkGLError("glUniform4f");
    }

    public void setUniformi(@Nonnull String name, int v1) {
        this.gl.glUniform1i(this.getLocation(name), v1);
        this.checkGLError("glUniform1i");
    }

    public void setUniformi(@Nonnull String name, int v1, int v2) {
        this.gl.glUniform2i(this.getLocation(name), v1, v2);
        this.checkGLError("glUniform2i");
    }

    public void setUniformi(@Nonnull String name, int v1, int v2, int v3) {
        this.gl.glUniform3i(this.getLocation(name), v1, v2, v3);
        this.checkGLError("glUniform3i");
    }

    public void setUniformi(@Nonnull String name, int v1, int v2, int v3, int v4) {
        this.gl.glUniform4i(this.getLocation(name), v1, v2, v3, v4);
        this.checkGLError("glUniform4i");
    }

    public void setUniformMatrix4f(@Nonnull String name, @Nonnull CoreMatrix4f matrix) {
        this.matrixBuffer.clear();
        matrix.store(this.matrixBuffer);
        this.matrixBuffer.rewind();
        this.gl.glUniformMatrix4(this.getLocation(name), false, this.matrixBuffer);
        this.checkGLError("glUniformMatrix4");
    }

    public void setUniformfArray(@Nonnull String name, float ... values) {
        FloatBuffer buffer = this.bufferFactory.createNativeOrderedFloatBuffer(values.length);
        buffer.put(values);
        buffer.rewind();
        this.gl.glUniform1(this.getLocation(name), buffer);
        this.checkGLError("glUniform1");
    }

    public int getAttribLocation(@Nonnull String name) {
        int result = this.gl.glGetAttribLocation(this.program, name);
        this.checkGLError("glGetAttribLocation");
        return result;
    }

    public void bindAttribLocation(@Nonnull String name, int index) {
        this.gl.glBindAttribLocation(this.program, index, name);
        this.checkGLError("glBindAttribLocation");
    }

    public void activate() {
        this.gl.glUseProgram(this.program);
        this.checkGLError("glUseProgram");
    }

    private CoreShader(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, String ... vertexAttributes) {
        this.gl = gl;
        this.bufferFactory = bufferFactory;
        this.attributes = vertexAttributes;
        this.matrixBuffer = bufferFactory.createNativeOrderedFloatBuffer(16);
        this.program = gl.glCreateProgram();
        this.params = bufferFactory.createNativeOrderedIntBuffer(1);
        this.checkGLError("glCreateProgram");
    }

    private int registerParameter(@Nonnull String name) {
        int location = this.getUniform(name);
        this.parameter.put(name, location);
        return location;
    }

    private int getLocation(@Nonnull String name) {
        Integer value = this.parameter.get(name);
        if (value == null) {
            return this.registerParameter(name);
        }
        return value;
    }

    private int getUniform(@Nonnull String uniformName) {
        int result = this.gl.glGetUniformLocation(this.program, uniformName);
        this.checkGLError("glGetUniformLocation for [" + uniformName + "] failed");
        log.info(this.getLoggingPrefix() + "glUniformLocation for [" + uniformName + "] = [" + result + "]");
        return result;
    }

    private void prepareShader(@Nonnull InputStream source, int shaderId) {
        this.gl.glShaderSource(shaderId, this.loadShader(source));
        this.checkGLError("glShaderSource");
        this.gl.glCompileShader(shaderId);
        this.checkGLError("glCompileShader");
        this.params.clear();
        this.gl.glGetShaderiv(shaderId, this.gl.GL_COMPILE_STATUS(), this.params);
        if (this.params.get(0) == this.gl.GL_FALSE()) {
            log.warning("compile error: " + this.gl.glGetShaderInfoLog(shaderId));
        }
        this.printLogInfo(shaderId);
        this.checkGLError(String.valueOf(shaderId));
    }

    private String loadShader(@Nonnull InputStream source) {
        byte[] data = this.read(source);
        return new String(data, Charset.forName("UTF-8"));
    }

    private byte[] read(@Nonnull InputStream dataStream) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] readBuffer = new byte[1024];
        try {
            int bytesRead;
            while ((bytesRead = dataStream.read(readBuffer)) > 0) {
                out.write(readBuffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                dataStream.close();
            }
            catch (IOException iOException) {}
        }
        return out.toByteArray();
    }

    private void printLogInfo(int obj) {
        String infoLog = this.gl.glGetShaderInfoLog(obj);
        this.checkGLError("glGetShaderInfoLog");
        log.info(this.getLoggingPrefix() + "Info log:\n" + infoLog);
    }

    private void checkGLError(@Nonnull String message) {
        CheckGL.checkGLError(this.gl, this.getLoggingPrefix() + message);
    }

    @Nonnull
    private String getLoggingPrefix() {
        return "[" + this.program + "] ";
    }

    @Nonnull
    private InputStream getStream(@Nonnull File file) throws FileNotFoundException {
        log.fine("loading shader file [" + file + "]");
        return new ByteArrayInputStream(this.read(new FileInputStream(file)));
    }

    @Nullable
    private InputStream getStream(@Nonnull String filename) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
    }
}

