/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch.core;

import de.lessvoid.nifty.render.batch.CheckGL;
import de.lessvoid.nifty.render.batch.spi.core.CoreGL;
import javax.annotation.Nonnull;

public class CoreRender {
    public static void renderTriangleStrip(@Nonnull CoreGL gl, int count) {
        gl.glDrawArrays(gl.GL_TRIANGLE_STRIP(), 0, count);
        CheckGL.checkGLError(gl, "glDrawArrays");
    }

    public static void renderTriangleFan(@Nonnull CoreGL gl, int count) {
        gl.glDrawArrays(gl.GL_TRIANGLE_FAN(), 0, count);
        CheckGL.checkGLError(gl, "glDrawArrays");
    }

    public static void renderTriangleStripInstances(@Nonnull CoreGL gl, int count, int primCount) {
        gl.glDrawArraysInstanced(gl.GL_TRIANGLE_STRIP(), 0, count, primCount);
        CheckGL.checkGLError(gl, "glDrawArraysInstanced(GL_TRIANGLE_STRIP)");
    }

    public static void renderTriangleStripIndexed(@Nonnull CoreGL gl, int count) {
        gl.glDrawElements(gl.GL_TRIANGLE_STRIP(), count, gl.GL_UNSIGNED_INT(), 0);
        CheckGL.checkGLError(gl, "glDrawElements(GL_TRIANGLE_STRIP)");
    }

    public static void renderTriangleFanIndexed(@Nonnull CoreGL gl, int count) {
        gl.glDrawElements(gl.GL_TRIANGLE_FAN(), count, gl.GL_UNSIGNED_INT(), 0);
        CheckGL.checkGLError(gl, "glDrawElements(GL_TRIANGLE_FAN)");
    }

    public static void renderTriangles(@Nonnull CoreGL gl, int vertexCount) {
        gl.glDrawArrays(gl.GL_TRIANGLES(), 0, vertexCount);
        CheckGL.checkGLError(gl, "glDrawArrays");
    }

    public static void renderTrianglesIndexed(@Nonnull CoreGL gl, int count) {
        gl.glDrawElements(gl.GL_TRIANGLES(), count, gl.GL_UNSIGNED_INT(), 0);
        CheckGL.checkGLError(gl, "glDrawElements");
    }

    public static void renderPoints(@Nonnull CoreGL gl, int count) {
        gl.glDrawArrays(gl.GL_POINTS(), 0, count);
        CheckGL.checkGLError(gl, "glDrawArrays(GL_POINTS)");
    }

    public static void renderPointsInstances(@Nonnull CoreGL gl, int count, int primCount) {
        gl.glDrawArraysInstanced(gl.GL_POINTS(), 0, count, primCount);
        CheckGL.checkGLError(gl, "glDrawArraysInstanced(GL_POINTS)");
    }
}

