/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch.core;

import de.lessvoid.nifty.render.batch.CheckGL;
import de.lessvoid.nifty.render.batch.spi.BufferFactory;
import de.lessvoid.nifty.render.batch.spi.core.CoreGL;
import java.nio.IntBuffer;
import javax.annotation.Nonnull;

public class CoreProfileSaveGLState {
    @Nonnull
    private final CoreGL gl;
    @Nonnull
    private final IntBuffer params;
    private int currentProgram;
    private int textureBinding;
    private int activeTexture;
    private int samplerBindingTex0;
    private boolean blending;
    private int blendingSrcFactor;
    private int blendingDstFactor;
    private boolean primitiveRestart;
    private int primitiveRestartIndex;

    public CoreProfileSaveGLState(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory) {
        this.gl = gl;
        this.params = bufferFactory.createNativeOrderedIntBuffer(16);
    }

    public void saveCore() {
        this.params.clear();
        this.gl.glGetIntegerv(this.gl.GL_CURRENT_PROGRAM(), this.params);
        this.currentProgram = this.params.get(0);
        this.params.clear();
        this.gl.glGetIntegerv(this.gl.GL_ACTIVE_TEXTURE(), this.params);
        this.activeTexture = this.params.get(0);
        this.params.clear();
        this.gl.glActiveTexture(this.gl.GL_TEXTURE0());
        this.gl.glGetIntegerv(this.gl.GL_SAMPLER_BINDING(), this.params);
        this.samplerBindingTex0 = this.params.get(0);
        this.params.clear();
        this.gl.glGetIntegerv(this.gl.GL_TEXTURE_BINDING_2D(), this.params);
        this.textureBinding = this.params.get(0);
        this.blending = this.gl.glIsEnabled(this.gl.GL_BLEND());
        this.params.clear();
        this.gl.glGetIntegerv(this.gl.GL_BLEND_SRC(), this.params);
        this.blendingSrcFactor = this.params.get(0);
        this.params.clear();
        this.gl.glGetIntegerv(this.gl.GL_BLEND_DST(), this.params);
        this.blendingDstFactor = this.params.get(0);
        this.primitiveRestart = this.gl.glIsEnabled(this.gl.GL_PRIMITIVE_RESTART());
        this.params.clear();
        this.gl.glGetIntegerv(this.gl.GL_PRIMITIVE_RESTART_INDEX(), this.params);
        this.primitiveRestartIndex = this.params.get(0);
        CheckGL.checkGLError(this.gl, "Failed to save OpenGL Core Profile state!", true);
    }

    public void restoreCore() {
        this.gl.glUseProgram(this.currentProgram);
        this.gl.glActiveTexture(this.activeTexture);
        this.gl.glBindSampler(0, this.samplerBindingTex0);
        this.gl.glBindTexture(this.gl.GL_TEXTURE_2D(), this.textureBinding);
        this.enable(this.gl.GL_BLEND(), this.blending);
        this.gl.glBlendFunc(this.blendingSrcFactor, this.blendingDstFactor);
        this.enable(this.gl.GL_PRIMITIVE_RESTART(), this.primitiveRestart);
        this.gl.glPrimitiveRestartIndex(this.primitiveRestartIndex);
        CheckGL.checkGLError(this.gl, "Failed to restore OpenGL Core Profile state!", true);
    }

    private void enable(int state, boolean value) {
        if (value) {
            this.gl.glEnable(state);
        } else {
            this.gl.glDisable(state);
        }
    }
}

