/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch.core;

import de.lessvoid.nifty.render.BlendMode;
import de.lessvoid.nifty.render.batch.core.CoreElementVBO;
import de.lessvoid.nifty.render.batch.core.CoreRender;
import de.lessvoid.nifty.render.batch.core.CoreShader;
import de.lessvoid.nifty.render.batch.core.CoreTexture2D;
import de.lessvoid.nifty.render.batch.core.CoreVAO;
import de.lessvoid.nifty.render.batch.core.CoreVBO;
import de.lessvoid.nifty.render.batch.spi.BufferFactory;
import de.lessvoid.nifty.render.batch.spi.core.CoreBatch;
import de.lessvoid.nifty.render.batch.spi.core.CoreGL;
import de.lessvoid.nifty.tools.Color;
import javax.annotation.Nonnull;

public class CoreBatchInternal
implements CoreBatch {
    private static final int PRIMITIVE_SIZE = 32;
    private static final int SIZE = 65536;
    @Nonnull
    private final CoreGL gl;
    @Nonnull
    private float[] primitiveBuffer = new float[32];
    @Nonnull
    private int[] elementIndexBuffer = new int[5];
    @Nonnull
    private BlendMode blendMode = BlendMode.BLEND;
    @Nonnull
    private final CoreVAO vao;
    @Nonnull
    private final CoreVBO vbo;
    @Nonnull
    private final CoreElementVBO elementVbo;
    private final int primitiveRestartIndex;
    private CoreTexture2D texture;
    private int primitiveCount;
    private int indexCount;
    private int globalIndex;

    public CoreBatchInternal(@Nonnull CoreGL gl, @Nonnull CoreShader shader, @Nonnull BufferFactory bufferFactory, int primitiveRestartIndex) {
        this.gl = gl;
        this.primitiveRestartIndex = primitiveRestartIndex;
        this.vao = new CoreVAO(gl, bufferFactory);
        this.vao.bind();
        this.elementVbo = CoreElementVBO.createStreamVBO(gl, bufferFactory, new int[65536]);
        this.elementVbo.bind();
        this.vbo = CoreVBO.createStreamVBO(gl, bufferFactory, new float[65536]);
        this.vbo.bind();
        this.vao.enableVertexAttributef(shader.getAttribLocation("aVertex"), 2, 8, 0);
        this.vao.enableVertexAttributef(shader.getAttribLocation("aColor"), 4, 8, 2);
        this.vao.enableVertexAttributef(shader.getAttribLocation("aTexture"), 2, 8, 6);
        this.primitiveCount = 0;
        this.globalIndex = 0;
        this.indexCount = 0;
        this.vao.unbind();
    }

    @Override
    public void begin(@Nonnull BlendMode blendMode, CoreTexture2D texture) {
        this.texture = texture;
        this.vao.bind();
        this.vbo.bind();
        this.vbo.getBuffer().clear();
        this.elementVbo.bind();
        this.elementVbo.getBuffer().clear();
        this.primitiveCount = 0;
        this.globalIndex = 0;
        this.indexCount = 0;
        this.vao.unbind();
    }

    @Override
    @Nonnull
    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    @Override
    public void render() {
        if (this.primitiveCount == 0) {
            return;
        }
        this.texture.bind();
        if (this.blendMode.equals((Object)BlendMode.BLEND)) {
            this.gl.glBlendFunc(this.gl.GL_SRC_ALPHA(), this.gl.GL_ONE_MINUS_SRC_ALPHA());
        } else if (this.blendMode.equals((Object)BlendMode.MULIPLY)) {
            this.gl.glBlendFunc(this.gl.GL_DST_COLOR(), this.gl.GL_ZERO());
        }
        this.vao.bind();
        this.vbo.getBuffer().flip();
        this.vbo.bind();
        this.vbo.send();
        this.elementVbo.getBuffer().flip();
        this.elementVbo.bind();
        this.elementVbo.send();
        CoreRender.renderTriangleStripIndexed(this.gl, this.indexCount);
    }

    @Override
    public boolean canAddQuad() {
        return (this.primitiveCount + 1) * 32 < 65536;
    }

    @Override
    public void addQuad(float x, float y, float width, float height, @Nonnull Color color1, @Nonnull Color color2, @Nonnull Color color3, @Nonnull Color color4, float textureX, float textureY, float textureWidth, float textureHeight) {
        int bufferIndex = 0;
        int elementIndexBufferIndex = 0;
        this.primitiveBuffer[bufferIndex++] = x;
        this.primitiveBuffer[bufferIndex++] = y + height;
        this.primitiveBuffer[bufferIndex++] = color3.getRed();
        this.primitiveBuffer[bufferIndex++] = color3.getGreen();
        this.primitiveBuffer[bufferIndex++] = color3.getBlue();
        this.primitiveBuffer[bufferIndex++] = color3.getAlpha();
        this.primitiveBuffer[bufferIndex++] = textureX;
        this.primitiveBuffer[bufferIndex++] = textureY + textureHeight;
        this.elementIndexBuffer[elementIndexBufferIndex++] = this.globalIndex++;
        this.primitiveBuffer[bufferIndex++] = x + width;
        this.primitiveBuffer[bufferIndex++] = y + height;
        this.primitiveBuffer[bufferIndex++] = color4.getRed();
        this.primitiveBuffer[bufferIndex++] = color4.getGreen();
        this.primitiveBuffer[bufferIndex++] = color4.getBlue();
        this.primitiveBuffer[bufferIndex++] = color4.getAlpha();
        this.primitiveBuffer[bufferIndex++] = textureX + textureWidth;
        this.primitiveBuffer[bufferIndex++] = textureY + textureHeight;
        this.elementIndexBuffer[elementIndexBufferIndex++] = this.globalIndex++;
        this.primitiveBuffer[bufferIndex++] = x;
        this.primitiveBuffer[bufferIndex++] = y;
        this.primitiveBuffer[bufferIndex++] = color1.getRed();
        this.primitiveBuffer[bufferIndex++] = color1.getGreen();
        this.primitiveBuffer[bufferIndex++] = color1.getBlue();
        this.primitiveBuffer[bufferIndex++] = color1.getAlpha();
        this.primitiveBuffer[bufferIndex++] = textureX;
        this.primitiveBuffer[bufferIndex++] = textureY;
        this.elementIndexBuffer[elementIndexBufferIndex++] = this.globalIndex++;
        this.primitiveBuffer[bufferIndex++] = x + width;
        this.primitiveBuffer[bufferIndex++] = y;
        this.primitiveBuffer[bufferIndex++] = color2.getRed();
        this.primitiveBuffer[bufferIndex++] = color2.getGreen();
        this.primitiveBuffer[bufferIndex++] = color2.getBlue();
        this.primitiveBuffer[bufferIndex++] = color2.getAlpha();
        this.primitiveBuffer[bufferIndex++] = textureX + textureWidth;
        this.primitiveBuffer[bufferIndex] = textureY;
        this.elementIndexBuffer[elementIndexBufferIndex++] = this.globalIndex++;
        this.elementIndexBuffer[elementIndexBufferIndex] = this.primitiveRestartIndex;
        this.indexCount += 5;
        this.vbo.getBuffer().put(this.primitiveBuffer);
        this.elementVbo.getBuffer().put(this.elementIndexBuffer);
        ++this.primitiveCount;
    }
}

