/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch;

import de.lessvoid.nifty.render.BlendMode;
import de.lessvoid.nifty.render.batch.BatchInternal;
import de.lessvoid.nifty.render.batch.CheckGL;
import de.lessvoid.nifty.render.batch.spi.Batch;
import de.lessvoid.nifty.render.batch.spi.BatchRenderBackend;
import de.lessvoid.nifty.render.batch.spi.BufferFactory;
import de.lessvoid.nifty.render.batch.spi.GL;
import de.lessvoid.nifty.render.batch.spi.ImageFactory;
import de.lessvoid.nifty.render.batch.spi.MouseCursorFactory;
import de.lessvoid.nifty.render.io.ImageLoader;
import de.lessvoid.nifty.render.io.ImageLoaderFactory;
import de.lessvoid.nifty.spi.render.MouseCursor;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.Factory;
import de.lessvoid.nifty.tools.ObjectPool;
import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BatchRenderBackendInternal
implements BatchRenderBackend {
    @Nonnull
    private static final Logger log = Logger.getLogger(BatchRenderBackendInternal.class.getName());
    private static final int INVALID_TEXTURE_ID = -1;
    @Nonnull
    private final GL gl;
    @Nonnull
    private final BufferFactory bufferFactory;
    @Nonnull
    private final ImageFactory imageFactory;
    @Nonnull
    private final MouseCursorFactory mouseCursorFactory;
    @Nonnull
    private final IntBuffer viewportBuffer;
    @Nonnull
    private final IntBuffer singleTextureIdBuffer;
    @Nonnull
    private final ObjectPool<Batch> batchPool;
    @Nonnull
    private final List<Batch> batches = new ArrayList<Batch>();
    @Nonnull
    private final ArrayList<Integer> nonAtlasTextureIds = new ArrayList();
    @Nonnull
    private final Map<Integer, Integer> atlasWidths = new HashMap<Integer, Integer>();
    @Nonnull
    private final Map<Integer, Integer> atlasHeights = new HashMap<Integer, Integer>();
    @Nonnull
    private final Map<String, MouseCursor> cursorCache = new HashMap<String, MouseCursor>();
    @Nullable
    private MouseCursor mouseCursor;
    @Nullable
    private NiftyResourceLoader resourceLoader;
    @Nullable
    private Batch currentBatch;
    private int viewportWidth;
    private int viewportHeight;
    private boolean shouldUseHighQualityTextures = false;
    private boolean shouldFillRemovedImagesInAtlas = false;

    public BatchRenderBackendInternal(final @Nonnull GL gl, final @Nonnull BufferFactory bufferFactory, @Nonnull ImageFactory imageFactory, @Nonnull MouseCursorFactory mouseCursorFactory) {
        this.gl = gl;
        this.bufferFactory = bufferFactory;
        this.imageFactory = imageFactory;
        this.mouseCursorFactory = mouseCursorFactory;
        this.viewportBuffer = bufferFactory.createNativeOrderedIntBuffer(16);
        this.singleTextureIdBuffer = bufferFactory.createNativeOrderedIntBuffer(1);
        this.batchPool = new ObjectPool<Batch>(new Factory<Batch>(){

            @Override
            @Nonnull
            public Batch createNew() {
                return new BatchInternal(gl, bufferFactory);
            }
        });
        this.initializeOpenGL();
    }

    @Override
    public void setResourceLoader(@Nonnull NiftyResourceLoader resourceLoader) {
        log.fine("setResourceLoader()");
        this.resourceLoader = resourceLoader;
    }

    @Override
    public int getWidth() {
        log.fine("getWidth()");
        this.updateViewport();
        return this.viewportWidth;
    }

    @Override
    public int getHeight() {
        log.fine("getHeight()");
        this.updateViewport();
        return this.viewportHeight;
    }

    @Override
    public void beginFrame() {
        log.fine("beginFrame()");
        this.deleteBatches();
    }

    @Override
    public void endFrame() {
        log.fine("endFrame()");
        CheckGL.checkGLError(this.gl);
    }

    @Override
    public void clear() {
        log.fine("clear()");
        this.clearGlColorBufferWithBlack();
    }

    @Override
    @Nullable
    public MouseCursor createMouseCursor(@Nonnull String filename, int hotspotX, int hotspotY) throws IOException {
        log.fine("createMouseCursor()");
        return this.existsCursor(filename) ? this.getCursor(filename) : this.createCursor(filename, hotspotX, hotspotY);
    }

    @Override
    public void enableMouseCursor(@Nonnull MouseCursor mouseCursor) {
        log.fine("enableMouseCursor()");
        this.mouseCursor = mouseCursor;
        mouseCursor.enable();
    }

    @Override
    public void disableMouseCursor() {
        if (this.mouseCursor != null) {
            log.fine("disableMouseCursor()");
            this.mouseCursor.disable();
        }
    }

    @Override
    public int createTextureAtlas(int atlasWidth, int atlasHeight) {
        log.fine("createTextureAtlas()");
        try {
            return this.createAtlasTextureInternal(atlasWidth, atlasHeight);
        }
        catch (Exception e) {
            this.textureCreationFailed(atlasWidth, atlasHeight, e);
            return -1;
        }
    }

    @Override
    public void clearTextureAtlas(int atlasTextureId) {
        log.fine("clearTextureAtlas()");
        this.bindGlTexture(atlasTextureId);
        this.updateCurrentlyBoundGlTexture(this.createBlankImageDataForAtlas(atlasTextureId), this.getAtlasWidth(atlasTextureId), this.getAtlasHeight(atlasTextureId));
    }

    @Override
    @Nonnull
    public BatchRenderBackend.Image loadImage(@Nonnull String filename) {
        log.fine("loadImage()");
        return this.createImageFromFile(filename);
    }

    @Override
    @Nullable
    public BatchRenderBackend.Image loadImage(@Nonnull ByteBuffer imageData, int imageWidth, int imageHeight) {
        log.fine("loadImage2()");
        return this.imageFactory.create(imageData, imageWidth, imageHeight);
    }

    @Override
    public void addImageToAtlas(@Nonnull BatchRenderBackend.Image image, int atlasX, int atlasY, int atlasTextureId) {
        log.fine("addImageToAtlas()");
        this.bindGlTexture(atlasTextureId);
        this.updateCurrentlyBoundGlTexture(this.imageFactory.asByteBuffer(image), atlasX, atlasY, image.getWidth(), image.getHeight());
    }

    @Override
    public int createNonAtlasTexture(@Nonnull BatchRenderBackend.Image image) {
        log.fine("createNonAtlasTexture()");
        try {
            return this.createNonAtlasTextureInternal(this.imageFactory.asByteBuffer(image), image.getWidth(), image.getHeight());
        }
        catch (Exception e) {
            this.textureCreationFailed(image.getWidth(), image.getHeight(), e);
            return -1;
        }
    }

    @Override
    public void deleteNonAtlasTexture(int textureId) {
        log.fine("deleteNonAtlasTexture()");
        try {
            this.deleteNonAtlasTextureInternal(textureId);
        }
        catch (Exception e) {
            this.textureDeletionFailed(textureId, e);
        }
    }

    @Override
    public boolean existsNonAtlasTexture(int textureId) {
        log.fine("existsNonAtlasTexture()");
        return this.nonAtlasTextureIds.contains(textureId);
    }

    @Override
    public void addQuad(float x, float y, float width, float height, @Nonnull Color color1, @Nonnull Color color2, @Nonnull Color color3, @Nonnull Color color4, float textureX, float textureY, float textureWidth, float textureHeight, int textureId) {
        log.fine("addQuad()");
        this.updateCurrentBatch(textureId);
        this.addQuadToCurrentBatch(x, y, width, height, color1, color2, color3, color4, textureX, textureY, textureWidth, textureHeight);
    }

    @Override
    public void beginBatch(@Nonnull BlendMode blendMode, int textureId) {
        log.fine("beginBatch()");
        this.currentBatch = this.createNewBatch();
        this.addBatch(this.currentBatch);
        this.currentBatch.begin(blendMode, textureId);
    }

    @Override
    public int render() {
        log.fine("render()");
        this.beginRendering();
        this.renderBatches();
        this.endRendering();
        return this.getTotalBatchesRendered();
    }

    @Override
    public void removeImageFromAtlas(@Nonnull BatchRenderBackend.Image image, int atlasX, int atlasY, int imageWidth, int imageHeight, int atlasTextureId) {
        if (!this.shouldFillRemovedImagesInAtlas) {
            return;
        }
        log.fine("removeImageFromAtlas()");
        this.bindGlTexture(atlasTextureId);
        this.updateCurrentlyBoundGlTexture(this.createBlankImageData(imageWidth, imageHeight), atlasX, atlasY, imageWidth, imageHeight);
    }

    @Override
    public void useHighQualityTextures(boolean shouldUseHighQualityTextures) {
        log.fine("useHighQualityTextures()");
        log.info(shouldUseHighQualityTextures ? "Using high quality textures (near & far bilinear filtering, mipmapping not supported in this implementation." : "Using low quality textures (no filtering).");
        this.shouldUseHighQualityTextures = shouldUseHighQualityTextures;
    }

    @Override
    public void fillRemovedImagesInAtlas(boolean shouldFill) {
        log.fine("fillRemovedImagesInAtlas()");
        log.info(shouldFill ? "Filling in removed images in atlas." : "Not filling in removed images in atlas.");
        this.shouldFillRemovedImagesInAtlas = shouldFill;
    }

    private void initializeOpenGL() {
        this.gl.glViewport(0, 0, this.getWidth(), this.getHeight());
        this.gl.glMatrixMode(this.gl.GL_PROJECTION());
        this.gl.glLoadIdentity();
        this.gl.glOrthof(0.0f, this.getWidth(), this.getHeight(), 0.0f, -9999.0f, 9999.0f);
        this.gl.glMatrixMode(this.gl.GL_MODELVIEW());
        this.gl.glLoadIdentity();
        this.gl.glDisable(this.gl.GL_DEPTH_TEST());
        this.gl.glDisable(this.gl.GL_CULL_FACE());
        this.gl.glDisable(this.gl.GL_LIGHTING());
        this.gl.glEnable(this.gl.GL_ALPHA_TEST());
        this.gl.glEnable(this.gl.GL_BLEND());
        this.gl.glEnable(this.gl.GL_TEXTURE_2D());
        this.gl.glAlphaFunc(this.gl.GL_NOTEQUAL(), 0.0f);
        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.gl.glClear(this.gl.GL_COLOR_BUFFER_BIT());
        this.gl.glTranslatef(0.375f, 0.375f, 0.0f);
    }

    private void updateViewport() {
        this.viewportBuffer.clear();
        this.gl.glGetIntegerv(this.gl.GL_VIEWPORT(), this.viewportBuffer);
        this.viewportWidth = this.viewportBuffer.get(2);
        this.viewportHeight = this.viewportBuffer.get(3);
        log.fine("Updated viewport: width: " + this.viewportWidth + ", height: " + this.viewportHeight);
    }

    @Nonnull
    private ByteBuffer createBlankImageDataForAtlas(int atlasTextureId) {
        return this.createBlankImageData(this.getAtlasWidth(atlasTextureId), this.getAtlasHeight(atlasTextureId));
    }

    @Nonnull
    private ByteBuffer createBlankImageData(int textureWidth, int textureHeight) {
        return this.bufferFactory.createNativeOrderedByteBuffer(textureWidth * textureHeight * 4);
    }

    private int getAtlasWidth(int atlasTextureId) {
        return this.atlasWidths.get(atlasTextureId);
    }

    private int getAtlasHeight(int atlasTextureId) {
        return this.atlasHeights.get(atlasTextureId);
    }

    private void deleteBatches() {
        for (Batch batch : this.batches) {
            this.batchPool.free(batch);
        }
        this.batches.clear();
    }

    private void clearGlColorBufferWithBlack() {
        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.gl.glClear(this.gl.GL_COLOR_BUFFER_BIT());
    }

    private int createAtlasTextureInternal(int width, int height) throws Exception {
        int atlasTextureId = this.createGlTexture(this.createBlankImageData(width, height), width, height);
        this.saveAtlasSize(atlasTextureId, width, height);
        return atlasTextureId;
    }

    private void textureCreationFailed(int textureWidth, int textureHeight, @Nonnull Exception exception) {
        log.log(Level.WARNING, "Failed to create texture of width: " + textureWidth + " & height: " + textureHeight + ".", exception);
    }

    private int createGlTexture(@Nullable ByteBuffer imageData, int textureWidth, int textureHeight) throws Exception {
        CheckGL.checkGLTextureSize(this.gl, textureWidth, textureHeight);
        int glTextureId = this.createTextureId();
        this.bindGlTexture(glTextureId);
        this.updateCurrentlyBoundGlTexture(imageData, textureWidth, textureHeight);
        this.setCurrentlyBoundGlTextureFilteringQuality(this.shouldUseHighQualityTextures);
        return glTextureId;
    }

    private void bindGlTexture(int textureId) {
        this.gl.glBindTexture(this.gl.GL_TEXTURE_2D(), textureId);
    }

    private void updateCurrentlyBoundGlTexture(@Nullable ByteBuffer imageData, int width, int height) {
        if (imageData == null) {
            log.warning("Attempted to update currently bound OpenGL texture with null image data!");
            return;
        }
        this.gl.glTexImage2D(this.gl.GL_TEXTURE_2D(), 0, this.gl.GL_RGBA(), width, height, 0, this.gl.GL_RGBA(), this.gl.GL_UNSIGNED_BYTE(), imageData);
        CheckGL.checkGLError(this.gl);
    }

    private void updateCurrentlyBoundGlTexture(@Nullable ByteBuffer imageData, int subTextureX, int subTextureY, int subTextureWidth, int subTextureHeight) {
        if (imageData == null) {
            log.warning("Attempted to update sub-texture of currently bound OpenGL texture with null image data!");
            return;
        }
        this.gl.glTexSubImage2D(this.gl.GL_TEXTURE_2D(), 0, subTextureX, subTextureY, subTextureWidth, subTextureHeight, this.gl.GL_RGBA(), this.gl.GL_UNSIGNED_BYTE(), imageData);
        CheckGL.checkGLError(this.gl);
    }

    private void setCurrentlyBoundGlTextureFilteringQuality(boolean isHighQuality) {
        if (isHighQuality) {
            this.gl.glTexParameterf(this.gl.GL_TEXTURE_2D(), this.gl.GL_TEXTURE_MIN_FILTER(), this.gl.GL_LINEAR());
            this.gl.glTexParameterf(this.gl.GL_TEXTURE_2D(), this.gl.GL_TEXTURE_MAG_FILTER(), this.gl.GL_LINEAR());
        } else {
            this.gl.glTexParameterf(this.gl.GL_TEXTURE_2D(), this.gl.GL_TEXTURE_MIN_FILTER(), this.gl.GL_NEAREST());
            this.gl.glTexParameterf(this.gl.GL_TEXTURE_2D(), this.gl.GL_TEXTURE_MAG_FILTER(), this.gl.GL_NEAREST());
        }
        CheckGL.checkGLError(this.gl);
    }

    private void saveAtlasSize(int atlasTextureId, int atlasWidth, int atlasHeight) {
        this.atlasWidths.put(atlasTextureId, atlasWidth);
        this.atlasHeights.put(atlasTextureId, atlasHeight);
    }

    private int createTextureId() {
        this.singleTextureIdBuffer.clear();
        this.gl.glGenTextures(1, this.singleTextureIdBuffer);
        CheckGL.checkGLError(this.gl);
        return this.singleTextureIdBuffer.get(0);
    }

    private int createNonAtlasTextureInternal(@Nullable ByteBuffer imageData, int width, int height) throws Exception {
        int textureId = this.createGlTexture(imageData, width, height);
        this.nonAtlasTextureIds.add(textureId);
        return textureId;
    }

    private void deleteNonAtlasTextureInternal(int nonAtlasTextureId) {
        this.singleTextureIdBuffer.clear();
        this.singleTextureIdBuffer.put(0, nonAtlasTextureId);
        this.gl.glDeleteTextures(1, this.singleTextureIdBuffer);
        CheckGL.checkGLError(this.gl);
        this.nonAtlasTextureIds.remove(nonAtlasTextureId);
    }

    private void textureDeletionFailed(int textureId, Exception exception) {
        log.log(Level.WARNING, "Failed to delete texture width id: " + textureId + ".", exception);
    }

    private void addQuadToCurrentBatch(float x, float y, float width, float height, @Nonnull Color color1, @Nonnull Color color2, @Nonnull Color color3, @Nonnull Color color4, float textureX, float textureY, float textureWidth, float textureHeight) {
        assert (this.currentBatch != null);
        this.currentBatch.addQuad(x, y, width, height, color1, color2, color3, color4, textureX, textureY, textureWidth, textureHeight);
    }

    private void updateCurrentBatch(int textureId) {
        if (this.shouldBeginBatch()) {
            this.beginBatch(this.getCurrentBlendMode(), textureId);
        }
    }

    @Nonnull
    private BlendMode getCurrentBlendMode() {
        assert (this.currentBatch != null);
        return this.currentBatch.getBlendMode();
    }

    private boolean shouldBeginBatch() {
        assert (this.currentBatch != null);
        return !this.currentBatch.canAddQuad();
    }

    @Nonnull
    private Batch createNewBatch() {
        return this.batchPool.allocate();
    }

    private void addBatch(@Nonnull Batch batch) {
        this.batches.add(batch);
    }

    private void renderBatches() {
        for (Batch batch : this.batches) {
            batch.render();
        }
    }

    private void beginRendering() {
        this.gl.glEnable(this.gl.GL_TEXTURE_2D());
        this.gl.glEnable(this.gl.GL_BLEND());
        this.gl.glEnableClientState(this.gl.GL_VERTEX_ARRAY());
        this.gl.glEnableClientState(this.gl.GL_COLOR_ARRAY());
        this.gl.glEnableClientState(this.gl.GL_TEXTURE_COORD_ARRAY());
    }

    private void endRendering() {
        this.gl.glDisableClientState(this.gl.GL_TEXTURE_COORD_ARRAY());
        this.gl.glDisableClientState(this.gl.GL_COLOR_ARRAY());
        this.gl.glDisableClientState(this.gl.GL_VERTEX_ARRAY());
        this.gl.glDisable(this.gl.GL_BLEND());
        this.gl.glDisable(this.gl.GL_TEXTURE_2D());
    }

    private int getTotalBatchesRendered() {
        return this.batches.size();
    }

    private boolean existsCursor(@Nonnull String filename) {
        return this.cursorCache.containsKey(filename);
    }

    @Nonnull
    private MouseCursor getCursor(@Nonnull String filename) {
        assert (this.cursorCache.containsKey(filename));
        return this.cursorCache.get(filename);
    }

    @Nullable
    private MouseCursor createCursor(String filename, int hotspotX, int hotspotY) {
        try {
            assert (this.resourceLoader != null);
            this.cursorCache.put(filename, this.mouseCursorFactory.create(filename, hotspotX, hotspotY, this.resourceLoader));
            return this.cursorCache.get(filename);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not create mouse cursor [" + filename + "]", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private BatchRenderBackend.Image createImageFromFile(@Nonnull String filename) {
        ImageLoader loader = ImageLoaderFactory.createImageLoader(filename);
        InputStream imageStream = null;
        try {
            assert (this.resourceLoader != null);
            imageStream = this.resourceLoader.getResourceAsStream(filename);
            if (imageStream != null) {
                ByteBuffer image = loader.loadAsByteBufferRGBA(imageStream);
                image.rewind();
                int width = loader.getImageWidth();
                int height = loader.getImageHeight();
                BatchRenderBackend.Image image2 = this.imageFactory.create(image, width, height);
                return image2;
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not load image from file: [" + filename + "]", e);
        }
        finally {
            if (imageStream != null) {
                try {
                    imageStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.imageFactory.create(null, 0, 0);
    }
}

