/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render;

import de.lessvoid.nifty.render.BlendMode;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.spi.render.MouseCursor;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.spi.render.RenderImage;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import java.io.IOException;
import javax.annotation.Nonnull;

public class ScalingRenderDevice
implements RenderDevice {
    private final NiftyRenderEngine renderEngine;
    private final RenderDevice internal;

    public ScalingRenderDevice(NiftyRenderEngine renderEngine, RenderDevice interal) {
        this.renderEngine = renderEngine;
        this.internal = interal;
    }

    @Override
    public void setResourceLoader(@Nonnull NiftyResourceLoader niftyResourceLoader) {
    }

    @Override
    public RenderImage createImage(@Nonnull String filename, boolean filterLinear) {
        return this.internal.createImage(filename, filterLinear);
    }

    @Override
    public RenderFont createFont(@Nonnull String filename) {
        return this.internal.createFont(filename);
    }

    @Override
    public int getWidth() {
        return this.internal.getWidth();
    }

    @Override
    public int getHeight() {
        return this.internal.getHeight();
    }

    @Override
    public void beginFrame() {
        this.internal.beginFrame();
    }

    @Override
    public void endFrame() {
        this.internal.endFrame();
    }

    @Override
    public void clear() {
        this.internal.clear();
    }

    @Override
    public void setBlendMode(@Nonnull BlendMode renderMode) {
        this.internal.setBlendMode(renderMode);
    }

    @Override
    public void renderQuad(int x, int y, int width, int height, @Nonnull Color color) {
        this.internal.renderQuad(this.renderEngine.convertToNativeX(x), this.renderEngine.convertToNativeY(y), this.renderEngine.convertToNativeWidth(width), this.renderEngine.convertToNativeHeight(height), color);
    }

    @Override
    public void renderQuad(int x, int y, int width, int height, @Nonnull Color topLeft, @Nonnull Color topRight, @Nonnull Color bottomRight, @Nonnull Color bottomLeft) {
        this.internal.renderQuad(this.renderEngine.convertToNativeX(x), this.renderEngine.convertToNativeY(y), this.renderEngine.convertToNativeWidth(width), this.renderEngine.convertToNativeHeight(height), topLeft, topRight, bottomRight, bottomLeft);
    }

    @Override
    public void renderImage(@Nonnull RenderImage image, int x, int y, int width, int height, @Nonnull Color color, float imageScale) {
        this.internal.renderImage(image, this.renderEngine.convertToNativeX(x), this.renderEngine.convertToNativeY(y), this.renderEngine.convertToNativeWidth(width), this.renderEngine.convertToNativeHeight(height), color, imageScale);
    }

    @Override
    public void renderImage(@Nonnull RenderImage image, int x, int y, int w, int h, int srcX, int srcY, int srcW, int srcH, @Nonnull Color color, float scale, int centerX, int centerY) {
        this.internal.renderImage(image, this.renderEngine.convertToNativeX(x), this.renderEngine.convertToNativeY(y), this.renderEngine.convertToNativeWidth(w), this.renderEngine.convertToNativeHeight(h), srcX, srcY, srcW, srcH, color, scale, this.renderEngine.convertToNativeX(centerX), this.renderEngine.convertToNativeY(centerY));
    }

    @Override
    public void renderFont(@Nonnull RenderFont font, @Nonnull String text, int x, int y, @Nonnull Color fontColor, float sizeX, float sizeY) {
        this.internal.renderFont(font, text, this.renderEngine.convertToNativeX(x), this.renderEngine.convertToNativeY(y), fontColor, this.renderEngine.convertToNativeTextSizeX(sizeX), this.renderEngine.convertToNativeTextSizeY(sizeY));
    }

    @Override
    public void enableClip(int x0, int y0, int x1, int y1) {
        this.internal.enableClip(this.renderEngine.convertToNativeX(x0), this.renderEngine.convertToNativeY(y0), this.renderEngine.convertToNativeX(x1), this.renderEngine.convertToNativeY(y1));
    }

    @Override
    public void disableClip() {
        this.internal.disableClip();
    }

    @Override
    public MouseCursor createMouseCursor(@Nonnull String filename, int hotspotX, int hotspotY) throws IOException {
        return this.internal.createMouseCursor(filename, hotspotX, hotspotY);
    }

    @Override
    public void enableMouseCursor(@Nonnull MouseCursor mouseCursor) {
        this.internal.enableMouseCursor(mouseCursor);
    }

    @Override
    public void disableMouseCursor() {
        this.internal.disableMouseCursor();
    }
}

