/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render;

import de.lessvoid.nifty.NiftyStopwatch;
import de.lessvoid.nifty.render.NiftyImageManagerExt;
import de.lessvoid.nifty.render.NiftyImageManagerExtBatch;
import de.lessvoid.nifty.render.NiftyImageManagerExtStandard;
import de.lessvoid.nifty.render.batch.BatchRenderDevice;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderImage;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NiftyImageManager {
    @Nonnull
    private static final Logger log = Logger.getLogger(NiftyImageManager.class.getName());
    @Nonnull
    private final RenderDevice renderDevice;
    @Nonnull
    private final Map<String, ReferencedCountedImage> imageCache = new HashMap<String, ReferencedCountedImage>();
    @Nonnull
    private final Map<RenderImage, ReferencedCountedImage> backReference = new HashMap<RenderImage, ReferencedCountedImage>();
    @Nonnull
    private final NiftyImageManagerExt<ReferencedCountedImage> ext;

    public NiftyImageManager(@Nonnull RenderDevice renderDevice) {
        this.renderDevice = renderDevice;
        this.ext = this.getExtImpl(renderDevice);
    }

    @Nullable
    public RenderImage registerImage(@Nonnull String filename, boolean filterLinear, @Nonnull Screen screen) {
        ReferencedCountedImage image = this.addImage(filename, filterLinear, screen);
        if (image == null) {
            return null;
        }
        this.ext.registerImage(screen, image);
        return image.getRenderImage();
    }

    public void unregisterImage(@Nonnull RenderImage image) {
        ReferencedCountedImage reference;
        if (this.backReference.containsKey(image) && this.removeImage(reference = this.backReference.get(image))) {
            this.ext.unregisterImage(reference);
        }
    }

    public void uploadScreenImages(@Nonnull Screen screen) {
        log.fine(">>> uploadScreenImages [" + screen.getScreenId() + "] start");
        NiftyStopwatch.start();
        this.ext.uploadScreenImages(screen);
        long time = NiftyStopwatch.stop();
        if (log.isLoggable(Level.FINE)) {
            log.fine("{" + String.format("%d", time) + " ms} <<< uploadScreenImages [" + screen.getScreenId() + "]");
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("{" + String.format("%d", time) + " ms} <<< uploadScreenImages [" + screen.getScreenId() + "] " + this.getInfoString());
        }
    }

    public void unloadScreenImages(@Nonnull Screen screen) {
        log.fine(">>> unloadScreenImages [" + screen.getScreenId() + "] start");
        NiftyStopwatch.start();
        this.ext.unloadScreenImages(screen, this.renderDevice, this.imageCache.values());
        long time = NiftyStopwatch.stop();
        if (log.isLoggable(Level.FINE)) {
            log.fine("{" + String.format("%d", time) + " ms} <<< unloadScreenImages [" + screen.getScreenId() + "]");
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("{" + String.format("%d", time) + " ms} <<< unloadScreenImages [" + screen.getScreenId() + "] " + this.getInfoString());
        }
    }

    public void screenAdded(@Nonnull Screen screen) {
        this.ext.screenAdded(screen);
        if (log.isLoggable(Level.FINER)) {
            log.finer("screenAdded [" + screen.getScreenId() + "] " + this.getInfoString());
        }
    }

    public void screenRemoved(@Nonnull Screen screen) {
        this.ext.screenRemoved(screen);
        if (log.isLoggable(Level.FINER)) {
            log.finer("screenRemoved [" + screen.getScreenId() + "] " + this.getInfoString());
        }
    }

    @Nonnull
    public RenderImage reload(@Nonnull RenderImage image) {
        if (this.backReference.containsKey(image)) {
            return this.backReference.get(image).reload();
        }
        return image;
    }

    @Nonnull
    public String getInfoString() {
        StringBuffer result = new StringBuffer();
        result.append(this.imageCache.size()).append(" entries in cache and ").append(this.backReference.size()).append(" backreference entries.");
        this.ext.addScreenInfo(result);
        return result.toString();
    }

    @Nonnull
    private NiftyImageManagerExt<ReferencedCountedImage> getExtImpl(RenderDevice renderer) {
        if (renderer instanceof BatchRenderDevice) {
            return new NiftyImageManagerExtBatch();
        }
        return new NiftyImageManagerExtStandard();
    }

    @Nonnull
    private static String buildName(@Nonnull String filename, boolean filterLinear) {
        return filename + "|" + Boolean.toString(filterLinear);
    }

    @Nullable
    private ReferencedCountedImage addImage(@Nonnull String filename, boolean filterLinear, @Nonnull Screen screen) {
        String key = NiftyImageManager.buildName(filename, filterLinear);
        if (this.imageCache.containsKey(key)) {
            ReferencedCountedImage existingImage = this.imageCache.get(key);
            existingImage.addReference();
            if (log.isLoggable(Level.FINER)) {
                log.finer("[" + screen.getScreenId() + "][" + key + "] refcount++ [" + existingImage.getReferences() + "]");
            }
            return existingImage;
        }
        NiftyStopwatch.start();
        RenderImage renderImage = this.renderDevice.createImage(filename, filterLinear);
        if (renderImage == null) {
            return null;
        }
        ReferencedCountedImage newImage = this.ext.createReferencedCountedImage(this.renderDevice, screen, filename, filterLinear, renderImage, key);
        this.backReference.put(renderImage, newImage);
        this.imageCache.put(key, newImage);
        NiftyStopwatch.stop("imageManager.getImage(" + filename + ")");
        return newImage;
    }

    private boolean removeImage(@Nonnull ReferencedCountedImage reference) {
        Screen screen = reference.getScreen();
        if (reference.removeReference()) {
            this.imageCache.remove(reference.getName());
            this.backReference.remove(reference.getRenderImage());
            if (log.isLoggable(Level.FINER)) {
                log.finer("[" + screen.getScreenId() + "][" + reference.getName() + "] refcount-- [" + reference.getReferences() + "] => DISPOSED");
            }
            return true;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("[" + screen.getScreenId() + "][" + reference.getName() + "] refcount-- [" + reference.getReferences() + "]");
        }
        return false;
    }

    public static interface ReferencedCountedImage {
        @Nonnull
        public RenderImage reload();

        @Nonnull
        public RenderImage addReference();

        public boolean removeReference();

        public int getReferences();

        @Nonnull
        public RenderImage getRenderImage();

        @Nonnull
        public String getName();

        @Nonnull
        public Screen getScreen();
    }
}

