/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render;

import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.batch.BatchRenderImage;
import de.lessvoid.nifty.render.image.ImageMode;
import de.lessvoid.nifty.render.image.ImageModeFactory;
import de.lessvoid.nifty.spi.render.RenderImage;
import de.lessvoid.nifty.tools.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NiftyImage {
    @Nonnull
    private RenderImage image;
    @Nonnull
    private ImageMode imageMode;
    @Nonnull
    private final NiftyRenderEngine niftyRenderEngine;
    @Nullable
    private Color color;

    public NiftyImage(@Nonnull NiftyRenderEngine niftyRenderEngine, @Nonnull RenderImage createImage) {
        this.niftyRenderEngine = niftyRenderEngine;
        this.image = createImage;
        this.imageMode = ImageModeFactory.getSharedInstance().createImageMode(null, null);
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public void render(int x, int y, int width, int height, Color color, float scale) {
        this.imageMode.render(this.niftyRenderEngine.getRenderDevice(), this.image, x, y, width, height, color, scale);
    }

    public void setImageMode(@Nonnull ImageMode imageMode) {
        this.imageMode = imageMode;
    }

    @Nonnull
    public ImageMode getImageMode() {
        return this.imageMode;
    }

    public void setColor(@Nullable Color color) {
        this.color = color;
    }

    @Nullable
    public Color getColor() {
        return this.color;
    }

    public void reload() {
        this.image = this.niftyRenderEngine.reload(this.image);
    }

    public void markBatchRenderImageAsUnloaded() {
        if (!(this.image instanceof BatchRenderImage)) {
            return;
        }
        BatchRenderImage batchRenderImage = (BatchRenderImage)this.image;
        batchRenderImage.markAsUnloaded();
    }

    public void dispose() {
        this.niftyRenderEngine.disposeImage(this.image);
    }
}

