/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types.helper;

import javax.annotation.Nonnull;

public class PaddingAttributeParser {
    @Nonnull
    private final String left;
    @Nonnull
    private final String right;
    @Nonnull
    private final String top;
    @Nonnull
    private final String bottom;

    public PaddingAttributeParser(@Nonnull String input) throws Exception {
        String[] values = input.split(",");
        if (values.length == 0) {
            throw new Exception("parsing error, paddingString is empty");
        }
        int valueCount = values.length;
        if (valueCount == 1) {
            if (values[0].length() == 0) {
                throw new Exception("parsing error, paddingString is empty");
            }
            this.left = values[0];
            this.right = values[0];
            this.top = values[0];
            this.bottom = values[0];
        } else if (valueCount == 2) {
            this.left = values[1];
            this.right = values[1];
            this.top = values[0];
            this.bottom = values[0];
        } else if (valueCount == 3) {
            this.left = values[1];
            this.right = values[1];
            this.top = values[0];
            this.bottom = values[2];
        } else if (valueCount == 4) {
            this.left = values[3];
            this.right = values[1];
            this.top = values[0];
            this.bottom = values[2];
        } else {
            throw new Exception("parsing error, paddingString count error (" + valueCount + ") expecting value from 1 to 4");
        }
    }

    @Nonnull
    public String getLeft() {
        return this.left;
    }

    @Nonnull
    public String getTop() {
        return this.top;
    }

    @Nonnull
    public String getRight() {
        return this.right;
    }

    @Nonnull
    public String getBottom() {
        return this.bottom;
    }
}

