/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types.apply;

import de.lessvoid.nifty.Size;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ImageRenderer;
import de.lessvoid.nifty.elements.render.PanelRenderer;
import de.lessvoid.nifty.loaderv2.types.apply.ApplyRenderer;
import de.lessvoid.nifty.loaderv2.types.apply.Convert;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.image.ImageMode;
import de.lessvoid.nifty.render.image.ImageModeHelper;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class ApplyRendererImage
implements ApplyRenderer {
    private static final Logger log = Logger.getLogger(ApplyRendererImage.class.getName());
    @Nonnull
    private final Convert convert;

    public ApplyRendererImage(@Nonnull Convert convertParam) {
        this.convert = convertParam;
    }

    @Override
    public void apply(@Nonnull Screen screen, @Nonnull Element element, @Nonnull Attributes attributes, @Nonnull NiftyRenderEngine renderEngine) {
        PanelRenderer panelRenderer = element.getRenderer(PanelRenderer.class);
        if (panelRenderer != null) {
            return;
        }
        ImageRenderer imageRenderer = element.getRenderer(ImageRenderer.class);
        if (imageRenderer == null) {
            return;
        }
        String filename = attributes.get("filename");
        if (filename == null) {
            return;
        }
        NiftyImage image = renderEngine.createImage(screen, filename, attributes.getAsBoolean("filter", false));
        if (image == null) {
            log.severe("Image for the filename \"" + filename + "\" couldn't be load.");
            return;
        }
        image.setColor(this.convert.color(attributes.get("color")));
        String areaProviderProperty = ImageModeHelper.getAreaProviderProperty(attributes.getAttributes());
        String renderStrategyProperty = ImageModeHelper.getRenderStrategyProperty(attributes.getAttributes());
        ImageMode imageMode = this.convert.imageMode(areaProviderProperty, renderStrategyProperty);
        image.setImageMode(imageMode);
        imageRenderer.setImage(image);
        imageRenderer.setInset(this.convert.insetSizeValue(attributes.get("inset"), image.getHeight()));
        Size imageDimension = imageMode.getImageNativeSize(image);
        if (element.getConstraintWidth().hasDefault()) {
            element.setConstraintWidth(SizeValue.def(imageDimension.getWidth()));
        }
        if (element.getConstraintHeight().hasDefault()) {
            element.setConstraintHeight(SizeValue.def(imageDimension.getHeight()));
        }
    }
}

