/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types;

import de.lessvoid.nifty.loaderv2.NiftyLoader;
import de.lessvoid.nifty.loaderv2.types.ControlDefinitionType;
import de.lessvoid.nifty.loaderv2.types.NiftyType;
import de.lessvoid.nifty.loaderv2.types.PopupType;
import de.lessvoid.nifty.loaderv2.types.ResourceBundleType;
import de.lessvoid.nifty.loaderv2.types.UseControlsType;
import de.lessvoid.nifty.loaderv2.types.XmlBaseType;
import de.lessvoid.nifty.loaderv2.types.helper.CollectionLogger;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;

public class NiftyControlsType
extends XmlBaseType {
    @Nonnull
    private final Collection<ControlDefinitionType> controlDefinitions = new ArrayList<ControlDefinitionType>();
    @Nonnull
    private final Collection<UseControlsType> useControls = new ArrayList<UseControlsType>();
    @Nonnull
    private final Collection<PopupType> popups = new ArrayList<PopupType>();
    @Nonnull
    private final Collection<ResourceBundleType> resourceBundles = new ArrayList<ResourceBundleType>();

    public void addControlDefinition(ControlDefinitionType controlDefinitionType) {
        this.controlDefinitions.add(controlDefinitionType);
    }

    public void addUseControls(UseControlsType useControlsType) {
        this.useControls.add(useControlsType);
    }

    public void addPopup(PopupType popupType) {
        this.popups.add(popupType);
    }

    public void addResourceBundle(ResourceBundleType resourceBundle) {
        this.resourceBundles.add(resourceBundle);
    }

    public void loadControls(@Nonnull NiftyLoader niftyLoader, @Nonnull NiftyType niftyType) throws Exception {
        for (UseControlsType useControl : this.useControls) {
            useControl.loadControl(niftyLoader, niftyType);
        }
        for (ControlDefinitionType controlDefinition : this.controlDefinitions) {
            niftyType.addControlDefinition(controlDefinition);
        }
        for (ResourceBundleType bundle : this.resourceBundles) {
            niftyType.addResourceBundle(bundle);
        }
        for (PopupType popup : this.popups) {
            niftyType.addPopup(popup);
        }
    }

    @Nonnull
    public String output() {
        int offset = 1;
        return "\nNifty Data:\n" + CollectionLogger.out(offset, this.controlDefinitions, "controlDefinitions") + "\n" + CollectionLogger.out(offset, this.useControls, "useControls");
    }
}

