/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectAttributes;
import de.lessvoid.nifty.effects.Effect;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.loaderv2.types.EffectValueType;
import de.lessvoid.nifty.loaderv2.types.RegisterEffectType;
import de.lessvoid.nifty.loaderv2.types.XmlBaseType;
import de.lessvoid.nifty.tools.LinearInterpolator;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EffectType
extends XmlBaseType
implements Cloneable {
    private static final Logger logger = Logger.getLogger(EffectType.class.getName());
    private static final boolean DEFAULT_INHERIT = false;
    private static final boolean DEFAULT_POST = false;
    private static final boolean DEFAULT_OVERLAY = false;
    @Nonnull
    protected List<EffectValueType> effectValues = new ArrayList<EffectValueType>();
    @Nullable
    private String styleId;

    public EffectType() {
    }

    public EffectType(@Nonnull Attributes attributes) {
        super(attributes);
    }

    @Override
    @Nonnull
    public EffectType clone() throws CloneNotSupportedException {
        try {
            EffectType newObject = (EffectType)super.clone();
            newObject.effectValues = new ArrayList<EffectValueType>(this.effectValues.size());
            for (EffectValueType effectValue : this.effectValues) {
                newObject.effectValues.add(effectValue.clone());
            }
            return newObject;
        }
        catch (ClassCastException e) {
            throw new CloneNotSupportedException("Cloning failed because the clone method created the wrong object.");
        }
    }

    @Nonnull
    public ControlEffectAttributes convert() {
        return new ControlEffectAttributes(this.getAttributes(), this.effectValues);
    }

    public void materialize(@Nonnull Nifty nifty, @Nonnull Element element, @Nonnull EffectEventId effectEventId, @Nonnull Attributes effectsTypeAttributes, @Nonnull List<Object> controllers) {
        Attributes effectAttributes = new Attributes(this.getAttributes());
        effectAttributes.merge(effectsTypeAttributes);
        RegisterEffectType registerEffectType = this.getRegisteredEffectType(nifty, effectAttributes);
        if (registerEffectType == null) {
            return;
        }
        Class<?> effectClass = registerEffectType.getEffectClass();
        if (effectClass == null) {
            return;
        }
        EffectProperties effectProperties = new EffectProperties(effectAttributes.createProperties());
        this.applyEffectValues(effectProperties);
        EffectImpl effectImpl = this.createEffectImpl(effectClass);
        if (effectImpl != null) {
            Effect effect = new Effect(nifty, this.getInherit(effectAttributes), this.getPost(effectAttributes), this.getOverlay(effectAttributes), this.getAlternateEnable(effectAttributes), this.getAlternateDisable(effectAttributes), this.getCustomKey(effectAttributes), this.getNeverStopRendering(effectAttributes), effectEventId, element, effectImpl, effectProperties, nifty.getTimeProvider(), controllers);
            this.initializeEffect(effect, effectEventId);
            element.registerEffect(effectEventId, effect);
        }
    }

    @Nullable
    private RegisterEffectType getRegisteredEffectType(@Nonnull Nifty nifty, @Nonnull Attributes attributes) {
        String name = this.getEffectName(attributes);
        RegisterEffectType registerEffectType = nifty.resolveRegisteredEffect(name);
        if (registerEffectType == null) {
            logger.warning("unable to convert effect [" + name + "] because no effect with this name has been registered.");
            return null;
        }
        return registerEffectType;
    }

    private boolean getInherit(@Nonnull Attributes attributes) {
        return attributes.getAsBoolean("inherit", false);
    }

    private boolean getPost(@Nonnull Attributes attributes) {
        return attributes.getAsBoolean("post", false);
    }

    private boolean getOverlay(@Nonnull Attributes attributes) {
        return attributes.getAsBoolean("overlay", false);
    }

    @Nullable
    private String getAlternateEnable(@Nonnull Attributes attributes) {
        return attributes.get("alternateEnable");
    }

    @Nullable
    private String getAlternateDisable(@Nonnull Attributes attributes) {
        return attributes.get("alternateDisable");
    }

    @Nullable
    private String getCustomKey(@Nonnull Attributes attributes) {
        return attributes.get("customKey");
    }

    private boolean getNeverStopRendering(@Nonnull Attributes attributes) {
        return attributes.getAsBoolean("neverStopRendering", false);
    }

    protected void initializeEffect(@Nonnull Effect effect, EffectEventId effectEventId) {
        if (EffectEventId.onFocus.equals((Object)effectEventId) || EffectEventId.onActive.equals((Object)effectEventId) || EffectEventId.onEnabled.equals((Object)effectEventId) || EffectEventId.onDisabled.equals((Object)effectEventId)) {
            effect.enableInfinite();
        }
    }

    @Nullable
    private EffectImpl createEffectImpl(@Nonnull Class<?> effectClass) {
        try {
            if (EffectImpl.class.isAssignableFrom(effectClass)) {
                return (EffectImpl)effectClass.newInstance();
            }
            logger.warning("given effect class [" + effectClass.getName() + "] does not implement [" + EffectImpl.class.getName() + "]");
        }
        catch (Exception e) {
            logger.warning("class [" + effectClass.getName() + "] could not be instanziated");
        }
        return null;
    }

    @Nullable
    private String getEffectName(@Nonnull Attributes attributes) {
        return attributes.get("name");
    }

    public void resolveParameters(@Nonnull Attributes src) {
        this.getAttributes().resolveParameters(src);
        for (EffectValueType e : this.effectValues) {
            e.getAttributes().resolveParameters(src);
        }
    }

    public void addValue(@Nonnull EffectValueType elementValueType) {
        this.effectValues.add(elementValueType);
    }

    public void addValues(@Nonnull Collection<EffectValueType> effectValueTypes) {
        this.effectValues.addAll(effectValueTypes);
    }

    void applyEffectValues(@Nonnull EffectProperties effectProperties) {
        if (!this.effectValues.isEmpty()) {
            LinearInterpolator interpolator;
            for (EffectValueType effectValueType : this.effectValues) {
                effectProperties.addEffectValue(effectValueType.getAttributes());
            }
            if (effectProperties.isTimeInterpolator() && (interpolator = effectProperties.getInterpolator()) != null) {
                effectProperties.setProperty("length", String.valueOf((long)interpolator.getMaxX()));
            }
        }
    }

    public void setStyleId(@Nullable String styleId) {
        this.styleId = styleId;
    }

    @Nullable
    public String getStyleId() {
        return this.styleId;
    }
}

