/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.layout.manager;

import de.lessvoid.nifty.layout.Box;
import de.lessvoid.nifty.layout.BoxConstraints;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.layout.align.HorizontalAlign;
import de.lessvoid.nifty.layout.manager.LayoutManager;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VerticalLayout
implements LayoutManager {
    @Override
    public void layoutElements(@Nonnull LayoutPart root, @Nonnull List<LayoutPart> children) {
        if (this.isInvalid(root, children)) {
            return;
        }
        int rootBoxX = this.getRootBoxX(root);
        int rootBoxY = this.getRootBoxY(root);
        int rootBoxWidth = this.getRootBoxWidth(root);
        int rootBoxHeight = this.getRootBoxHeight(root);
        int y = rootBoxY;
        for (int i = 0; i < children.size(); ++i) {
            int elementHeight;
            int elementWidth;
            Box currentBox = children.get(i).getBox();
            BoxConstraints currentBoxConstraints = children.get(i).getBoxConstraints();
            if (this.hasHeightConstraint(currentBoxConstraints) && currentBoxConstraints.getHeight().hasWidthSuffix()) {
                elementWidth = this.processWidthConstraints(rootBoxWidth, currentBoxConstraints, 0);
                currentBox.setWidth(elementWidth);
                elementHeight = this.calcElementHeight(children, rootBoxHeight, currentBoxConstraints, elementWidth);
                currentBox.setHeight(elementHeight);
            } else if (this.hasWidthConstraint(currentBoxConstraints) && currentBoxConstraints.getWidth().hasHeightSuffix()) {
                elementHeight = this.calcElementHeight(children, rootBoxHeight, currentBoxConstraints, 0);
                currentBox.setHeight(elementHeight);
                elementWidth = this.processWidthConstraints(rootBoxWidth, currentBoxConstraints, elementHeight);
                currentBox.setWidth(elementWidth);
            } else {
                elementWidth = this.processWidthConstraints(rootBoxWidth, currentBoxConstraints, 0);
                currentBox.setWidth(elementWidth);
                elementHeight = this.calcElementHeight(children, rootBoxHeight, currentBoxConstraints, 0);
                currentBox.setHeight(elementHeight);
            }
            int x = this.processHorizontalAlignment(rootBoxX, rootBoxWidth, currentBox.getWidth(), currentBoxConstraints);
            currentBox.setX(x += this.leftMargin(currentBoxConstraints, rootBoxWidth));
            currentBox.setY(y += this.topMargin(currentBoxConstraints, rootBoxHeight));
            y += elementHeight + this.bottomMargin(currentBoxConstraints, rootBoxHeight);
        }
    }

    private int leftMargin(@Nonnull BoxConstraints boxConstraints, int rootBoxWidth) {
        return boxConstraints.getMarginLeft().getValueAsInt(rootBoxWidth);
    }

    private int topMargin(@Nonnull BoxConstraints boxConstraints, int rootBoxHeight) {
        return boxConstraints.getMarginTop().getValueAsInt(rootBoxHeight);
    }

    private int bottomMargin(@Nonnull BoxConstraints boxConstraints, int rootBoxHeight) {
        return boxConstraints.getMarginBottom().getValueAsInt(rootBoxHeight);
    }

    @Override
    @Nonnull
    public SizeValue calculateConstraintWidth(@Nonnull LayoutPart root, @Nonnull List<LayoutPart> children) {
        return root.getMaxWidth(children);
    }

    @Override
    @Nonnull
    public SizeValue calculateConstraintHeight(@Nonnull LayoutPart root, @Nonnull List<LayoutPart> children) {
        return root.getSumHeight(children);
    }

    private int processWidthConstraints(int rootBoxWidth, @Nonnull BoxConstraints constraints, int elementHeight) {
        if (this.hasWidthConstraint(constraints)) {
            if (constraints.getWidth().hasHeightSuffix()) {
                return constraints.getWidth().getValueAsInt(elementHeight);
            }
            return constraints.getWidth().getValueAsInt(rootBoxWidth);
        }
        return rootBoxWidth;
    }

    private int processHorizontalAlignment(int rootBoxX, int rootBoxWidth, int currentBoxWidth, @Nonnull BoxConstraints constraints) {
        if (HorizontalAlign.center.equals((Object)constraints.getHorizontalAlign())) {
            return rootBoxX + (rootBoxWidth - currentBoxWidth) / 2;
        }
        if (HorizontalAlign.right.equals((Object)constraints.getHorizontalAlign())) {
            return rootBoxX + (rootBoxWidth - currentBoxWidth);
        }
        if (HorizontalAlign.left.equals((Object)constraints.getHorizontalAlign())) {
            return rootBoxX;
        }
        return rootBoxX;
    }

    private int calcElementHeight(@Nonnull List<LayoutPart> children, int rootBoxHeight, @Nonnull BoxConstraints boxConstraints, int boxWidth) {
        int h;
        if (this.hasHeightConstraint(boxConstraints) && (h = boxConstraints.getHeight().hasWidthSuffix() ? boxConstraints.getHeight().getValueAsInt(boxWidth) : boxConstraints.getHeight().getValueAsInt(rootBoxHeight)) != -1) {
            return h;
        }
        return this.getMaxNonFixedHeight(children, rootBoxHeight);
    }

    private int getMaxNonFixedHeight(@Nonnull List<LayoutPart> elements, int parentHeight) {
        int maxFixedHeight = 0;
        int fixedCount = 0;
        for (int i = 0; i < elements.size(); ++i) {
            LayoutPart p = elements.get(i);
            BoxConstraints original = p.getBoxConstraints();
            if (!this.hasHeightConstraint(original) || !original.getHeight().hasValue()) continue;
            maxFixedHeight += original.getHeight().getValueAsInt(parentHeight);
            ++fixedCount;
        }
        int notFixedCount = elements.size() - fixedCount;
        if (notFixedCount > 0) {
            return (parentHeight - maxFixedHeight) / notFixedCount;
        }
        return parentHeight - maxFixedHeight;
    }

    private boolean hasWidthConstraint(@Nullable BoxConstraints constraint) {
        return constraint != null && constraint.getWidth().hasValue();
    }

    private boolean hasHeightConstraint(@Nullable BoxConstraints boxConstraints) {
        return boxConstraints != null && boxConstraints.getHeight().hasValue();
    }

    private boolean isInvalid(@Nullable LayoutPart root, @Nullable List<LayoutPart> children) {
        return root == null || children == null || children.size() == 0;
    }

    private int getRootBoxX(@Nonnull LayoutPart root) {
        return root.getBox().getX() + root.getBoxConstraints().getPaddingLeft().getValueAsInt(root.getBox().getWidth());
    }

    private int getRootBoxY(@Nonnull LayoutPart root) {
        return root.getBox().getY() + root.getBoxConstraints().getPaddingTop().getValueAsInt(root.getBox().getHeight());
    }

    private int getRootBoxWidth(@Nonnull LayoutPart root) {
        return root.getBox().getWidth() - root.getBoxConstraints().getPaddingLeft().getValueAsInt(root.getBox().getWidth()) - root.getBoxConstraints().getPaddingRight().getValueAsInt(root.getBox().getWidth());
    }

    private int getRootBoxHeight(@Nonnull LayoutPart root) {
        return root.getBox().getHeight() - root.getBoxConstraints().getPaddingTop().getValueAsInt(root.getBox().getHeight()) - root.getBoxConstraints().getPaddingBottom().getValueAsInt(root.getBox().getHeight());
    }
}

