/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.layout.manager;

import de.lessvoid.nifty.layout.Box;
import de.lessvoid.nifty.layout.BoxConstraints;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.layout.align.VerticalAlign;
import de.lessvoid.nifty.layout.manager.LayoutManager;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HorizontalLayout
implements LayoutManager {
    @Override
    public final void layoutElements(@Nonnull LayoutPart root, @Nonnull List<LayoutPart> children) {
        if (this.isInvalid(root, children)) {
            return;
        }
        int rootBoxX = this.getRootBoxX(root);
        int rootBoxY = this.getRootBoxY(root);
        int rootBoxWidth = this.getRootBoxWidth(root);
        int rootBoxHeight = this.getRootBoxHeight(root);
        int x = rootBoxX;
        for (int i = 0; i < children.size(); ++i) {
            int elementWidth;
            int elementHeight;
            LayoutPart current = children.get(i);
            Box box = current.getBox();
            BoxConstraints boxConstraints = current.getBoxConstraints();
            if (boxConstraints.getWidth().hasHeightSuffix()) {
                elementHeight = this.processHeightConstraint(rootBoxHeight, box, boxConstraints, 0);
                box.setHeight(elementHeight);
                elementWidth = this.calcElementWidth(children, rootBoxWidth, boxConstraints, elementHeight);
                box.setWidth(elementWidth);
            } else if (this.hasHeightConstraint(boxConstraints) && boxConstraints.getHeight().hasWidthSuffix()) {
                elementWidth = this.calcElementWidth(children, rootBoxWidth, boxConstraints, 0);
                box.setWidth(elementWidth);
                elementHeight = this.processHeightConstraint(rootBoxHeight, box, boxConstraints, elementWidth);
                box.setHeight(elementHeight);
            } else {
                elementWidth = this.calcElementWidth(children, rootBoxWidth, boxConstraints, 0);
                box.setWidth(elementWidth);
                elementHeight = this.processHeightConstraint(rootBoxHeight, box, boxConstraints, 0);
                box.setHeight(elementHeight);
            }
            int y = this.processVerticalAlignment(rootBoxY, rootBoxHeight, box, boxConstraints);
            box.setY(y += this.topMargin(boxConstraints, rootBoxHeight));
            box.setX(x += this.leftMargin(boxConstraints, rootBoxWidth));
            x += elementWidth + this.rightMargin(boxConstraints, rootBoxWidth);
        }
    }

    private int leftMargin(@Nonnull BoxConstraints boxConstraints, int rootBoxWidth) {
        return boxConstraints.getMarginLeft().getValueAsInt(rootBoxWidth);
    }

    private int rightMargin(@Nonnull BoxConstraints boxConstraints, int rootBoxWidth) {
        return boxConstraints.getMarginRight().getValueAsInt(rootBoxWidth);
    }

    private int topMargin(@Nonnull BoxConstraints boxConstraints, int rootBoxHeight) {
        return boxConstraints.getMarginTop().getValueAsInt(rootBoxHeight);
    }

    private int processHeightConstraint(int rootBoxHeight, Box box, @Nonnull BoxConstraints constraint, int elementWidth) {
        if (this.hasHeightConstraint(constraint)) {
            if (constraint.getHeight().hasWidthSuffix()) {
                return constraint.getHeight().getValueAsInt(elementWidth);
            }
            return constraint.getHeight().getValueAsInt(rootBoxHeight);
        }
        return rootBoxHeight;
    }

    private boolean hasHeightConstraint(@Nullable BoxConstraints constraint) {
        return constraint != null && constraint.getHeight().hasValue();
    }

    private int calcElementWidth(@Nonnull List<LayoutPart> children, int rootBoxWidth, @Nonnull BoxConstraints boxConstraints, int elementHeight) {
        if (boxConstraints.getWidth().hasValue()) {
            int h = boxConstraints.getWidth().getValueAsInt(rootBoxWidth);
            if (boxConstraints.getWidth().hasHeightSuffix()) {
                h = boxConstraints.getWidth().getValueAsInt(elementHeight);
            }
            if (h != -1) {
                return h;
            }
        }
        return this.getMaxNonFixedWidth(children, rootBoxWidth);
    }

    private int processVerticalAlignment(int rootBoxY, int rootBoxHeight, @Nonnull Box box, @Nonnull BoxConstraints boxConstraints) {
        if (VerticalAlign.center.equals((Object)boxConstraints.getVerticalAlign())) {
            return rootBoxY + (rootBoxHeight - box.getHeight()) / 2;
        }
        if (VerticalAlign.top.equals((Object)boxConstraints.getVerticalAlign())) {
            return rootBoxY;
        }
        if (VerticalAlign.bottom.equals((Object)boxConstraints.getVerticalAlign())) {
            return rootBoxY + (rootBoxHeight - box.getHeight());
        }
        return rootBoxY;
    }

    private int getMaxNonFixedWidth(@Nonnull List<LayoutPart> elements, int parentWidth) {
        int maxFixedWidth = 0;
        int fixedCount = 0;
        for (int i = 0; i < elements.size(); ++i) {
            LayoutPart p = elements.get(i);
            BoxConstraints original = p.getBoxConstraints();
            if (!original.getWidth().hasValue()) continue;
            maxFixedWidth += original.getWidth().getValueAsInt(parentWidth);
            ++fixedCount;
        }
        int notFixedCount = elements.size() - fixedCount;
        if (notFixedCount > 0) {
            return (parentWidth - maxFixedWidth) / notFixedCount;
        }
        return parentWidth - maxFixedWidth;
    }

    @Override
    @Nonnull
    public final SizeValue calculateConstraintWidth(@Nonnull LayoutPart root, @Nonnull List<LayoutPart> children) {
        return root.getSumWidth(children);
    }

    @Override
    @Nonnull
    public final SizeValue calculateConstraintHeight(@Nonnull LayoutPart root, @Nonnull List<LayoutPart> children) {
        return root.getMaxHeight(children);
    }

    private boolean isInvalid(@Nullable LayoutPart root, @Nullable List<LayoutPart> children) {
        return root == null || children == null || children.size() == 0;
    }

    private int getRootBoxX(@Nonnull LayoutPart root) {
        return root.getBox().getX() + root.getBoxConstraints().getPaddingLeft().getValueAsInt(root.getBox().getWidth());
    }

    private int getRootBoxY(@Nonnull LayoutPart root) {
        return root.getBox().getY() + root.getBoxConstraints().getPaddingTop().getValueAsInt(root.getBox().getHeight());
    }

    private int getRootBoxWidth(@Nonnull LayoutPart root) {
        return root.getBox().getWidth() - root.getBoxConstraints().getPaddingLeft().getValueAsInt(root.getBox().getWidth()) - root.getBoxConstraints().getPaddingRight().getValueAsInt(root.getBox().getWidth());
    }

    private int getRootBoxHeight(@Nonnull LayoutPart root) {
        return root.getBox().getHeight() - root.getBoxConstraints().getPaddingTop().getValueAsInt(root.getBox().getHeight()) - root.getBoxConstraints().getPaddingBottom().getValueAsInt(root.getBox().getHeight());
    }
}

