/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.layout.manager;

import de.lessvoid.nifty.layout.Box;
import de.lessvoid.nifty.layout.BoxConstraints;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.layout.align.HorizontalAlign;
import de.lessvoid.nifty.layout.align.VerticalAlign;
import de.lessvoid.nifty.layout.manager.LayoutManager;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CenterLayout
implements LayoutManager {
    @Override
    public void layoutElements(@Nullable LayoutPart rootElement, @Nullable List<LayoutPart> elements) {
        if (rootElement == null || elements == null || elements.size() == 0) {
            return;
        }
        Box rootBox = rootElement.getBox();
        BoxConstraints rootBoxConstraints = rootElement.getBoxConstraints();
        for (int i = 0; i < elements.size(); ++i) {
            this.layoutElement(elements.get(i), rootBox, rootBoxConstraints);
        }
    }

    private int leftMargin(@Nonnull BoxConstraints boxConstraints, int rootBoxWidth) {
        return boxConstraints.getMarginLeft().getValueAsInt(rootBoxWidth);
    }

    private int rightMargin(@Nonnull BoxConstraints boxConstraints, int rootBoxWidth) {
        return boxConstraints.getMarginRight().getValueAsInt(rootBoxWidth);
    }

    private int topMargin(@Nonnull BoxConstraints boxConstraints, int rootBoxHeight) {
        return boxConstraints.getMarginTop().getValueAsInt(rootBoxHeight);
    }

    private int bottomMargin(@Nonnull BoxConstraints boxConstraints, int rootBoxHeight) {
        return boxConstraints.getMarginBottom().getValueAsInt(rootBoxHeight);
    }

    private void layoutElement(@Nonnull LayoutPart element, @Nonnull Box rootBox, @Nonnull BoxConstraints rootBoxConstraints) {
        Box box = element.getBox();
        BoxConstraints constraint = element.getBoxConstraints();
        if (constraint.getWidth().hasHeightSuffix()) {
            this.handleVerticalAlignment(rootBox, rootBoxConstraints, box, constraint);
            this.handleHorizontalAlignment(rootBox, rootBoxConstraints, box, constraint);
        } else if (constraint.getHeight().hasWidthSuffix()) {
            this.handleHorizontalAlignment(rootBox, rootBoxConstraints, box, constraint);
            this.handleVerticalAlignment(rootBox, rootBoxConstraints, box, constraint);
        } else {
            this.handleVerticalAlignment(rootBox, rootBoxConstraints, box, constraint);
            this.handleHorizontalAlignment(rootBox, rootBoxConstraints, box, constraint);
        }
        box.setX(box.getX() + this.leftMargin(constraint, rootBox.getWidth()) - this.rightMargin(constraint, rootBox.getWidth()));
        box.setY(box.getY() + this.topMargin(constraint, rootBox.getHeight()) - this.bottomMargin(constraint, rootBox.getHeight()));
    }

    void handleHorizontalAlignment(@Nonnull Box rootBox, @Nonnull BoxConstraints rootBoxConstraints, @Nonnull Box box, @Nonnull BoxConstraints constraint) {
        if (constraint.getWidth().hasValue()) {
            this.handleWidthConstraint(rootBox, rootBoxConstraints, box, constraint);
        } else {
            box.setX(rootBox.getX() + rootBoxConstraints.getPaddingLeft().getValueAsInt(rootBox.getWidth()));
            box.setWidth(rootBox.getWidth() - rootBoxConstraints.getPaddingLeft().getValueAsInt(rootBox.getWidth()) - rootBoxConstraints.getPaddingRight().getValueAsInt(rootBox.getWidth()));
        }
    }

    void handleVerticalAlignment(@Nonnull Box rootBox, @Nonnull BoxConstraints rootBoxConstraints, @Nonnull Box box, @Nonnull BoxConstraints constraint) {
        if (constraint.getHeight().hasValue()) {
            this.handleHeightConstraint(rootBox, rootBoxConstraints, box, constraint);
        } else {
            box.setY(rootBox.getY() + rootBoxConstraints.getPaddingTop().getValueAsInt(rootBox.getHeight()));
            box.setHeight(rootBox.getHeight() - rootBoxConstraints.getPaddingTop().getValueAsInt(rootBox.getHeight()) - rootBoxConstraints.getPaddingBottom().getValueAsInt(rootBox.getHeight()));
        }
    }

    private void handleWidthConstraint(@Nonnull Box rootBox, @Nonnull BoxConstraints rootBoxConstraints, @Nonnull Box box, @Nonnull BoxConstraints constraint) {
        int rootBoxX = rootBox.getX() + rootBoxConstraints.getPaddingLeft().getValueAsInt(rootBox.getWidth());
        int rootBoxWidth = rootBox.getWidth() - rootBoxConstraints.getPaddingLeft().getValueAsInt(rootBox.getWidth()) - rootBoxConstraints.getPaddingRight().getValueAsInt(rootBox.getWidth());
        int boxWidth = constraint.getWidth().getValueAsInt(rootBoxWidth);
        if (constraint.getWidth().hasHeightSuffix()) {
            boxWidth = constraint.getWidth().getValueAsInt(box.getHeight());
        }
        box.setWidth(boxWidth);
        if (constraint.getHorizontalAlign() == HorizontalAlign.left) {
            box.setX(rootBoxX);
        } else if (constraint.getHorizontalAlign() == HorizontalAlign.right) {
            box.setX(rootBoxX + rootBox.getWidth() - rootBoxConstraints.getPaddingRight().getValueAsInt(rootBox.getWidth()) - boxWidth);
        } else {
            box.setX(rootBoxX + (rootBoxWidth - boxWidth) / 2);
        }
    }

    private void handleHeightConstraint(@Nonnull Box rootBox, @Nonnull BoxConstraints rootBoxConstraints, @Nonnull Box box, @Nonnull BoxConstraints constraint) {
        int rootBoxY = rootBox.getY() + rootBoxConstraints.getPaddingTop().getValueAsInt(rootBox.getHeight());
        int rootBoxHeight = rootBox.getHeight() - rootBoxConstraints.getPaddingTop().getValueAsInt(rootBox.getHeight()) - rootBoxConstraints.getPaddingBottom().getValueAsInt(rootBox.getHeight());
        int boxHeight = constraint.getHeight().getValueAsInt(rootBoxHeight);
        if (constraint.getHeight().hasWidthSuffix()) {
            boxHeight = constraint.getHeight().getValueAsInt(box.getWidth());
        }
        box.setHeight(boxHeight);
        if (constraint.getVerticalAlign() == VerticalAlign.top) {
            box.setY(rootBoxY);
        } else if (constraint.getVerticalAlign() == VerticalAlign.bottom) {
            box.setY(rootBoxY + rootBox.getHeight() - rootBoxConstraints.getPaddingBottom().getValueAsInt(rootBox.getHeight()) - boxHeight);
        } else {
            box.setY(rootBoxY + (rootBoxHeight - boxHeight) / 2);
        }
    }

    @Override
    @Nonnull
    public SizeValue calculateConstraintWidth(@Nonnull LayoutPart root, @Nonnull List<LayoutPart> children) {
        return root.getMaxWidth(children);
    }

    @Override
    @Nonnull
    public SizeValue calculateConstraintHeight(@Nonnull LayoutPart root, @Nonnull List<LayoutPart> children) {
        return root.getMaxHeight(children);
    }
}

