/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements;

import de.lessvoid.nifty.elements.Action;
import de.lessvoid.nifty.elements.Element;
import java.util.List;
import javax.annotation.Nonnull;

public class ElementMoveAction
implements Action {
    @Nonnull
    private final Element movedElement;
    @Nonnull
    private final Element destinationElement;

    public ElementMoveAction(@Nonnull Element movedElement, @Nonnull Element destinationElement) {
        this.movedElement = movedElement;
        this.destinationElement = destinationElement;
    }

    @Override
    public void perform() {
        if (this.movedElement.hasParent()) {
            this.movedElement.getParent().internalRemoveElement(this.movedElement);
        }
        this.movedElement.setParent(this.destinationElement);
        this.destinationElement.addChild(this.movedElement);
        this.addToFocusHandler(this.movedElement);
        this.movedElement.getParent().layoutElements();
        this.destinationElement.layoutElements();
    }

    private void addToFocusHandler(@Nonnull Element element) {
        if (element.isFocusable()) {
            element.getFocusHandler().addElement(element);
        }
        List<Element> children = element.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            this.addToFocusHandler(children.get(i));
        }
    }
}

