/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TextColorAnimated
implements EffectImpl {
    @Nonnull
    private final Color currentColor = new Color("#000f");
    @Nonnull
    private final Color tempColor = new Color("#000f");
    private Color startColor;
    private Color endColor;

    @Override
    public void activate(@Nonnull Nifty nifty, @Nonnull Element element, @Nonnull EffectProperties parameter) {
        this.startColor = new Color(parameter.getProperty("startColor", "#0000"));
        this.endColor = new Color(parameter.getProperty("endColor", "#ffff"));
    }

    @Override
    public void execute(@Nonnull Element element, float normalizedTime, @Nullable Falloff falloff, @Nonnull NiftyRenderEngine r) {
        this.currentColor.linear(this.startColor, this.endColor, normalizedTime);
        if (falloff == null) {
            this.setColor(r, this.currentColor);
        } else {
            this.tempColor.multiply(this.currentColor, falloff.getFalloffValue());
            this.setColor(r, this.tempColor);
        }
    }

    private void setColor(@Nonnull NiftyRenderEngine r, @Nonnull Color color) {
        if (r.isColorAlphaChanged()) {
            r.setColorIgnoreAlpha(color);
        } else {
            r.setColor(color);
        }
    }

    @Override
    public void deactivate() {
    }
}

