/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.nifty.tools.TargetElementResolver;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleHint
implements EffectImpl {
    @Nullable
    private Element targetElement;
    @Nullable
    private String hintText;

    @Override
    public void activate(@Nonnull Nifty nifty, @Nonnull Element element, @Nonnull EffectProperties parameter) {
        Screen screen = nifty.getCurrentScreen();
        if (screen == null) {
            return;
        }
        TargetElementResolver resolver = new TargetElementResolver(nifty.getCurrentScreen(), element);
        this.targetElement = resolver.resolve(parameter.getProperty("targetElement"));
        String text = parameter.getProperty("hintText");
        if (text != null) {
            this.hintText = text;
        }
    }

    @Override
    public void execute(@Nonnull Element element, float normalizedTime, @Nullable Falloff falloff, @Nonnull NiftyRenderEngine r) {
        TextRenderer textRenderer;
        if (this.targetElement != null && (textRenderer = this.targetElement.getRenderer(TextRenderer.class)) != null) {
            textRenderer.setText(this.hintText == null ? "Missing Hint Text!" : this.hintText);
            this.targetElement.setConstraintWidth(SizeValue.px(textRenderer.getTextWidth()));
            element.getParent().layoutElements();
        }
    }

    @Override
    public void deactivate() {
    }
}

