/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.image.ImageModeFactory;
import de.lessvoid.nifty.render.image.ImageModeHelper;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.pulsate.Pulsator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImageOverlayPulsate
implements EffectImpl {
    @Nullable
    private NiftyImage image;
    @Nullable
    private Pulsator pulsater;

    @Override
    public void activate(@Nonnull Nifty nifty, @Nonnull Element element, @Nonnull EffectProperties parameter) {
        Screen screen = nifty.getCurrentScreen();
        if (screen == null) {
            return;
        }
        this.image = nifty.getRenderEngine().createImage(screen, parameter.getProperty("filename"), true);
        if (this.image == null) {
            return;
        }
        String areaProviderProperty = ImageModeHelper.getAreaProviderProperty(parameter);
        String renderStrategyProperty = ImageModeHelper.getRenderStrategyProperty(parameter);
        if (areaProviderProperty != null || renderStrategyProperty != null) {
            this.image.setImageMode(ImageModeFactory.getSharedInstance().createImageMode(areaProviderProperty, renderStrategyProperty));
        }
        this.pulsater = new Pulsator(parameter, nifty.getTimeProvider());
    }

    @Override
    public void execute(@Nonnull Element element, float normalizedTime, @Nullable Falloff falloff, @Nonnull NiftyRenderEngine r) {
        if (this.image != null) {
            r.saveStates();
            if (this.pulsater != null) {
                r.setColorAlpha(this.pulsater.update());
            }
            r.renderImage(this.image, element.getX(), element.getY(), element.getWidth(), element.getHeight());
            r.restoreStates();
        }
    }

    @Override
    public void deactivate() {
        if (this.image != null) {
            this.image.dispose();
        }
    }
}

