/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.loaderv2.types.helper.PaddingAttributeParser;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Border
implements EffectImpl {
    private static final Logger log = Logger.getLogger(Border.class.getName());
    @Nonnull
    private Color colorLeft = Color.WHITE;
    @Nonnull
    private Color colorRight = Color.WHITE;
    @Nonnull
    private Color colorTop = Color.WHITE;
    @Nonnull
    private Color colorBottom = Color.WHITE;
    @Nonnull
    private SizeValue borderLeft = SizeValue.px(1);
    @Nonnull
    private SizeValue borderRight = SizeValue.px(1);
    @Nonnull
    private SizeValue borderTop = SizeValue.px(1);
    @Nonnull
    private SizeValue borderBottom = SizeValue.px(1);
    @Nonnull
    private SizeValue insetLeft = SizeValue.px(0);
    @Nonnull
    private SizeValue insetRight = SizeValue.px(0);
    @Nonnull
    private SizeValue insetTop = SizeValue.px(0);
    @Nonnull
    private SizeValue insetBottom = SizeValue.px(0);

    @Override
    public void activate(@Nonnull Nifty nifty, @Nonnull Element element, @Nonnull EffectProperties parameter) {
        try {
            PaddingAttributeParser parser = new PaddingAttributeParser(parameter.getProperty("border", "1px"));
            this.borderLeft = new SizeValue(parser.getLeft());
            this.borderRight = new SizeValue(parser.getRight());
            this.borderTop = new SizeValue(parser.getTop());
            this.borderBottom = new SizeValue(parser.getBottom());
            parser = new PaddingAttributeParser(parameter.getProperty("color", "#ffff"));
            this.colorLeft = new Color(parser.getLeft());
            this.colorRight = new Color(parser.getRight());
            this.colorTop = new Color(parser.getTop());
            this.colorBottom = new Color(parser.getBottom());
            parser = new PaddingAttributeParser(parameter.getProperty("inset", "0px"));
            this.insetLeft = new SizeValue(parser.getLeft());
            this.insetRight = new SizeValue(parser.getRight());
            this.insetTop = new SizeValue(parser.getTop());
            this.insetBottom = new SizeValue(parser.getBottom());
        }
        catch (Exception e) {
            log.warning(e.getMessage());
        }
    }

    @Override
    public void execute(@Nonnull Element element, float normalizedTime, @Nullable Falloff falloff, @Nonnull NiftyRenderEngine r) {
        r.saveStates();
        int left = this.getBorder(element, this.borderLeft);
        int right = this.getBorder(element, this.borderRight);
        int top = this.getBorder(element, this.borderTop);
        int bottom = this.getBorder(element, this.borderBottom);
        int insetOffsetLeft = this.insetLeft.getValueAsInt(element.getWidth());
        int insetOffsetRight = this.insetRight.getValueAsInt(element.getWidth());
        int insetOffsetTop = this.insetTop.getValueAsInt(element.getHeight());
        int insetOffsetBottom = this.insetBottom.getValueAsInt(element.getHeight());
        if (left > 0) {
            this.setAlphaSaveColor(r, this.colorLeft);
            r.renderQuad(element.getX() - left + insetOffsetLeft, element.getY() - top + insetOffsetTop, left, element.getHeight() + top + bottom - insetOffsetTop - insetOffsetBottom);
        }
        if (right > 0) {
            this.setAlphaSaveColor(r, this.colorRight);
            r.renderQuad(element.getX() + element.getWidth() - insetOffsetRight, element.getY() - top + insetOffsetTop, right, element.getHeight() + top + bottom - insetOffsetTop - insetOffsetBottom);
        }
        if (top > 0) {
            this.setAlphaSaveColor(r, this.colorTop);
            r.renderQuad(element.getX() - left + insetOffsetLeft, element.getY() - top + insetOffsetTop, element.getWidth() + left + right - insetOffsetLeft - insetOffsetRight, top);
        }
        if (bottom > 0) {
            this.setAlphaSaveColor(r, this.colorBottom);
            r.renderQuad(element.getX() - left + insetOffsetLeft, element.getY() + element.getHeight() - insetOffsetBottom, element.getWidth() + left + right - insetOffsetLeft - insetOffsetRight, bottom);
        }
        r.restoreStates();
    }

    private void setAlphaSaveColor(@Nonnull NiftyRenderEngine r, @Nonnull Color color) {
        if (r.isColorAlphaChanged()) {
            r.setColorIgnoreAlpha(color);
        } else {
            r.setColor(color);
        }
    }

    private int getBorder(@Nonnull Element element, @Nonnull SizeValue sizeValue) {
        if (!element.hasParent()) {
            return 0;
        }
        int parentWidth = sizeValue.getValueAsInt(element.getParent().getWidth());
        if (parentWidth < 0) {
            return 0;
        }
        return parentWidth;
    }

    @Override
    public void deactivate() {
    }
}

