/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects;

import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.Properties;
import javax.annotation.Nonnull;

public class Falloff {
    @Nonnull
    public static final String HOVER_FALLOFF_TYPE = "hoverFalloffType";
    @Nonnull
    public static final String HOVER_FALLOFF_CONSTRAINT = "hoverFalloffConstraint";
    @Nonnull
    public static final String HOVER_WIDTH = "hoverWidth";
    @Nonnull
    public static final String HOVER_HEIGHT = "hoverHeight";
    @Nonnull
    private final HoverFalloffConstraint falloffConstraint;
    @Nonnull
    private final HoverFalloffType falloffType;
    @Nonnull
    private final SizeValue hoverWidth;
    @Nonnull
    private final SizeValue hoverHeight;
    private float falloffValue;

    public Falloff(@Nonnull Properties properties) {
        String falloffTypeString = properties.getProperty(HOVER_FALLOFF_TYPE);
        this.falloffType = falloffTypeString != null ? HoverFalloffType.valueOf(falloffTypeString) : HoverFalloffType.none;
        String falloffConstraintString = properties.getProperty(HOVER_FALLOFF_CONSTRAINT);
        this.falloffConstraint = falloffConstraintString != null ? HoverFalloffConstraint.valueOf(falloffConstraintString) : HoverFalloffConstraint.none;
        this.hoverWidth = new SizeValue(properties.getProperty(HOVER_WIDTH));
        this.hoverHeight = new SizeValue(properties.getProperty(HOVER_HEIGHT));
    }

    public void applyProperties(Properties properties) {
    }

    public final boolean isInside(@Nonnull Element element, int x, int y) {
        int centerX = element.getX() + element.getWidth() / 2;
        int centerY = element.getY() + element.getHeight() / 2;
        int horizontalHover = this.getHorizontalHover(element);
        int verticalHover = this.getVerticalHover(element);
        return x > centerX - horizontalHover / 2 && x <= centerX + horizontalHover / 2 && y > centerY - verticalHover / 2 && y <= centerY + verticalHover / 2;
    }

    private int getVerticalHover(@Nonnull Element element) {
        return this.hoverHeight.hasValue() ? this.hoverHeight.getValueAsInt(element.getHeight()) : element.getHeight();
    }

    private int getHorizontalHover(@Nonnull Element element) {
        return this.hoverWidth.hasValue() ? this.hoverWidth.getValueAsInt(element.getWidth()) : element.getWidth();
    }

    public void updateFalloffValue(@Nonnull Element element, int mouseX, int mouseY) {
        float d;
        if (this.falloffConstraint == HoverFalloffConstraint.none || this.falloffType == HoverFalloffType.none) {
            this.falloffValue = 1.0f;
            return;
        }
        int centerX = element.getX() + element.getWidth() / 2;
        int centerY = element.getY() + element.getHeight() / 2;
        float dx = mouseX - centerX;
        float dy = mouseY - centerY;
        float falloff = 0.0f;
        if (this.falloffConstraint == HoverFalloffConstraint.vertical) {
            dx = 0.0f;
            falloff = this.getVerticalHover(element) / 2;
        }
        if (this.falloffConstraint == HoverFalloffConstraint.horizontal) {
            dy = 0.0f;
            falloff = this.getHorizontalHover(element) / 2;
        }
        if (this.falloffConstraint == HoverFalloffConstraint.both) {
            double dA = (double)dy == 0.0 && (double)dx == 0.0 ? 0.0 : Math.abs(Math.atan(dy / dx));
            float elA = this.getHorizontalHover(element) / 2;
            float elB = this.getVerticalHover(element) / 2;
            double dB = Math.abs(Math.atan(elB / elA));
            if (Math.abs(Math.toDegrees(dA)) >= 0.0 && Math.abs(Math.toDegrees(dA)) <= Math.abs(Math.toDegrees(dB))) {
                falloff = (float)((double)elA / Math.cos(dA));
            }
            if (Math.abs(Math.toDegrees(dA)) > Math.abs(Math.toDegrees(dB)) && Math.abs(Math.toDegrees(dA)) <= 90.0) {
                falloff = (float)((double)elB / Math.sin(dA));
            }
        }
        if ((d = (float)Math.hypot(dx, dy)) > falloff) {
            this.falloffValue = 0.0f;
        }
        this.falloffValue = Math.abs(1.0f - d / falloff);
    }

    public float getFalloffValue() {
        return this.falloffValue;
    }

    @Nonnull
    public HoverFalloffConstraint getFalloffConstraint() {
        return this.falloffConstraint;
    }

    public static enum HoverFalloffConstraint {
        none,
        vertical,
        horizontal,
        both;

    }

    public static enum HoverFalloffType {
        none,
        linear;

    }
}

