/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dynamic;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.screen.DefaultScreenController;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import de.lessvoid.xml.tools.ClassHelper;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ScreenCreator {
    @Nonnull
    private static final Logger log = Logger.getLogger(ScreenCreator.class.getName());
    @Nonnull
    private final String id;
    @Nullable
    private ScreenController screenController;
    @Nullable
    private String defaultFocusElement;
    @Nullable
    private String inputMapping;
    @Nullable
    private String inputMappingPre;

    public ScreenCreator(@Nonnull String id) {
        this(id, null);
    }

    public ScreenCreator(@Nonnull String id, @Nullable ScreenController screenController) {
        this.id = id;
        this.screenController = screenController;
    }

    public void setScreenController(@Nullable ScreenController screenController) {
        this.screenController = screenController;
    }

    public void setDefaultFocusElement(@Nullable String defaultFocusElement) {
        this.defaultFocusElement = defaultFocusElement;
    }

    public void setInputMapping(@Nullable String inputMapping) {
        this.inputMapping = inputMapping;
    }

    public void setInputMappingPre(@Nullable String inputMappingPre) {
        this.inputMappingPre = inputMappingPre;
    }

    @Nonnull
    public Screen create(@Nonnull Nifty nifty) {
        Screen screen = this.createScreen(nifty);
        this.addRootElement(nifty, screen);
        this.addDefaultFocusElement(screen);
        this.addInputMapping(screen, this.inputMapping);
        this.addPreInputMapping(screen, this.inputMappingPre);
        nifty.addScreen(this.id, screen);
        return screen;
    }

    @Nonnull
    private Screen createScreen(@Nonnull Nifty nifty) {
        ScreenController usedController = this.screenController;
        if (usedController == null) {
            log.warning("Missing ScreenController for screen [" + this.id + "] using DefaultScreenController() instead but this might not be what you want.");
            usedController = new DefaultScreenController();
        }
        return new Screen(nifty, this.id, usedController, nifty.getTimeProvider());
    }

    private void addRootElement(@Nonnull Nifty nifty, @Nonnull Screen screen) {
        Element rootElement = nifty.getRootLayerFactory().createRootLayer("root", nifty, screen, nifty.getTimeProvider());
        screen.setRootElement(rootElement);
    }

    private void addDefaultFocusElement(@Nonnull Screen screen) {
        screen.setDefaultFocusElement(this.defaultFocusElement);
    }

    private void addInputMapping(@Nonnull Screen screen, @Nullable String inputMappingClass) {
        NiftyInputMapping inputMapping;
        if (inputMappingClass != null && (inputMapping = ClassHelper.getInstance(inputMappingClass, NiftyInputMapping.class)) != null) {
            if (!(this.screenController instanceof KeyInputHandler)) {
                log.warning("class [" + this.screenController + "] tries to use inputMapping [" + inputMappingClass + "] but does not implement [" + KeyInputHandler.class.getName() + "]");
            } else {
                screen.addKeyboardInputHandler(inputMapping, (KeyInputHandler)KeyInputHandler.class.cast(this.screenController));
            }
        }
    }

    private void addPreInputMapping(@Nonnull Screen screen, @Nullable String inputMappingClass) {
        NiftyInputMapping inputMapping;
        if (inputMappingClass != null && (inputMapping = ClassHelper.getInstance(inputMappingClass, NiftyInputMapping.class)) != null) {
            if (!(this.screenController instanceof KeyInputHandler)) {
                log.warning("class [" + this.screenController + "] tries to use inputMapping [" + inputMappingClass + "] but does not implement [" + KeyInputHandler.class.getName() + "]");
            } else {
                screen.addPreKeyboardInputHandler(inputMapping, (KeyInputHandler)KeyInputHandler.class.cast(this.screenController));
            }
        }
    }
}

