/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.tools.Color;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Parameters {
    @Nonnull
    private final Properties parameters = new Properties();

    public Parameters(@Nonnull Properties properties) {
        this.parameters.putAll((Map<?, ?>)properties);
    }

    public boolean isSet(@Nonnull String name) {
        return this.parameters.get(name) != null;
    }

    @Deprecated
    public boolean containsKey(@Nonnull String name) {
        return this.isSet(name);
    }

    @Nullable
    public String get(@Nonnull String name) {
        return this.parameters.getProperty(name);
    }

    @Nonnull
    public String getWithDefault(@Nonnull String name, @Nonnull String defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Nullable
    @Deprecated
    public String getProperty(@Nonnull String name) {
        return this.get(name);
    }

    @Nonnull
    @Deprecated
    public String getProperty(@Nonnull String name, @Nonnull String defaultValue) {
        return this.getWithDefault(name, defaultValue);
    }

    public boolean getAsBoolean(@Nonnull String name, boolean defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        return defaultValue;
    }

    @Nullable
    public Integer getAsInteger(@Nonnull String name) {
        String value = this.get(name);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public int getAsInteger(@Nonnull String name, int defaultValue) {
        Integer result = this.getAsInteger(name);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    @Nullable
    public Float getAsFloat(@Nonnull String name) {
        String value = this.get(name);
        if (value == null) {
            return null;
        }
        try {
            return Float.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public float getAsFloat(@Nonnull String name, float defaultValue) {
        Float result = this.getAsFloat(name);
        if (result == null) {
            return defaultValue;
        }
        return result.floatValue();
    }

    @Nullable
    public Color getAsColor(@Nonnull String name) {
        String value = this.get(name);
        if (value == null) {
            return null;
        }
        if (Color.check(value)) {
            return new Color(value);
        }
        return null;
    }

    @Nonnull
    public Color getAsColor(@Nonnull String name, @Nonnull Color defaultValue) {
        Color result = this.getAsColor(name);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    @Nullable
    public <T extends Enum<T>> T getAsEnum(@Nonnull String name, @Nonnull Class<T> enumClass) {
        String value = this.get(name);
        if (value == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass, value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nonnull
    public <T extends Enum<T>> T getAsEnum(@Nonnull String name, @Nonnull Class<T> enumClass, @Nonnull T defaultValue) {
        T result = this.getAsEnum(name, enumClass);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }
}

